/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.components;

import edu.iu.nwb.analysis.extractnetfromtable.components.AggregateFunctionMappings;
import edu.iu.nwb.analysis.extractnetfromtable.components.EdgeContainer;
import edu.iu.nwb.analysis.extractnetfromtable.components.InvalidColumnNameException;
import edu.iu.nwb.analysis.extractnetfromtable.components.NodeID;
import edu.iu.nwb.analysis.extractnetfromtable.components.NodeMaintainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.utilities.StringUtilities;
import org.osgi.service.log.LogService;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.column.Column;
import prefuse.util.collections.IntIterator;

public class GraphContainer {
    public static final String TARGET_COLUMN_NAME = "target";
    public static final String SOURCE_COLUMN_NAME = "source";
    public static final String LABEL_COLUMN_NAME = "label";
    private Graph graph;
    private Table table;
    private AggregateFunctionMappings nodeFunctionMap;
    private AggregateFunctionMappings edgeFunctionMap;
    private ProgressMonitor progressMonitor = null;

    public GraphContainer(Graph graph, Table table, AggregateFunctionMappings nodeFunctionMap, AggregateFunctionMappings edgeFunctionMap, ProgressMonitor progressMonitor) {
        this.graph = graph;
        this.table = table;
        this.nodeFunctionMap = nodeFunctionMap;
        this.edgeFunctionMap = edgeFunctionMap;
        this.progressMonitor = progressMonitor;
    }

    public Graph buildGraph(String sourceColumnName, String targetColumnName, String delimiter, boolean requestBipartite, LogService log) {
        String[] targetColumnNames = targetColumnName.split("\\,");
        if (this.graph.isDirected()) {
            return this.buildDirectedGraph(sourceColumnName, targetColumnNames, delimiter, requestBipartite, log);
        }
        return this.buildUndirectedGraph(targetColumnNames, delimiter, log);
    }

    private Graph buildUndirectedGraph(String[] targetColumnNames, String delimiter, LogService log) {
        boolean duplicateValues = false;
        HashMap dupValuesErrorMessages = new HashMap();
        int numTotalRows = this.table.getRowCount();
        int numRowsProcessedSoFar = 0;
        NodeMaintainer nodeMaintainer = new NodeMaintainer();
        if (this.progressMonitor != null) {
            this.progressMonitor.start(2, numTotalRows);
        }
        int recordsWithSkippedColumns = 0;
        IntIterator rowIt = this.table.rows();
        while (rowIt.hasNext()) {
            boolean rowHasSkippedColumns = false;
            int row = (Integer)rowIt.next();
            Node node1 = null;
            Node node2 = null;
            String targetString = GraphContainer.buildRowTargetStringFromColumnNames(row, targetColumnNames, this.table, delimiter);
            HashSet<String> seenObject = new HashSet<String>();
            if (targetString != null) {
                Pattern splitPattern = Pattern.compile("\\Q" + delimiter + "\\E");
                String[] splitTargetStringArray = GraphContainer.splitIfDelimiterIsValid(targetString, delimiter, splitPattern);
                int ii = 0;
                while (ii < splitTargetStringArray.length) {
                    splitTargetStringArray[ii] = GraphContainer.normalizeLabel(splitTargetStringArray[ii]);
                    ++ii;
                }
                ii = splitTargetStringArray.length - 1;
                while (ii >= 0) {
                    if (!"".equals(splitTargetStringArray[ii])) {
                        if (seenObject.add(splitTargetStringArray[ii])) {
                            node1 = nodeMaintainer.mutateNode(splitTargetStringArray[ii], null, this.graph, this.table, row, this.nodeFunctionMap, 0);
                            if (nodeMaintainer.hasSkippedColumns) {
                                rowHasSkippedColumns = true;
                                nodeMaintainer.hasSkippedColumns = false;
                            }
                        }
                        node1 = this.graph.getNode(this.nodeFunctionMap.getFunctionRow(new NodeID(splitTargetStringArray[ii], null)).getRowNumber());
                        int jj = 0;
                        while (jj < ii) {
                            if (!"".equals(splitTargetStringArray[jj])) {
                                if (!splitTargetStringArray[jj].equals(splitTargetStringArray[ii])) {
                                    if (seenObject.add(splitTargetStringArray[jj])) {
                                        node2 = nodeMaintainer.mutateNode(splitTargetStringArray[jj], null, this.graph, this.table, row, this.nodeFunctionMap, 0);
                                    }
                                    node2 = this.graph.getNode(this.nodeFunctionMap.getFunctionRow(new NodeID(splitTargetStringArray[jj], null)).getRowNumber());
                                    EdgeContainer edgeContainer = new EdgeContainer();
                                    edgeContainer.mutateEdge(node1, node2, this.graph, this.table, row, this.edgeFunctionMap);
                                    if (edgeContainer.hasSkippedColumns) {
                                        rowHasSkippedColumns = true;
                                        edgeContainer.hasSkippedColumns = false;
                                    }
                                } else {
                                    duplicateValues = true;
                                }
                            }
                            ++jj;
                        }
                    }
                    --ii;
                }
            }
            ++numRowsProcessedSoFar;
            if (this.progressMonitor != null) {
                this.progressMonitor.worked(numRowsProcessedSoFar);
            }
            if (!rowHasSkippedColumns) continue;
            ++recordsWithSkippedColumns;
        }
        Iterator dupIter = dupValuesErrorMessages.keySet().iterator();
        while (dupIter.hasNext()) {
            log.log(2, (String)dupValuesErrorMessages.get(dupIter.next()));
        }
        if (recordsWithSkippedColumns > 0) {
            log.log(2, String.valueOf(recordsWithSkippedColumns) + " records had empty values or parsing issues and were skipped.");
        }
        return this.graph;
    }

    private static String normalizeLabel(String label) {
        String[] parts = label.trim().split("\\s+");
        int ii = 0;
        while (ii < parts.length) {
            parts[ii] = GraphContainer.capitalize(parts[ii]);
            ++ii;
        }
        return StringUtilities.implodeStringArray((String[])parts, (String)" ");
    }

    private static String capitalize(String s) {
        if (s.length() <= 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1).toLowerCase();
    }

    private Graph buildDirectedGraph(String sourceColumnName, String[] targetColumnNames, String delimiter, boolean requestBipartite, LogService log) {
        Pattern splitPattern = Pattern.compile("\\Q" + delimiter + "\\E");
        HashMap dupValuesErrorMessages = new HashMap();
        Column sourceColumn = this.table.getColumn(sourceColumnName);
        NodeMaintainer nodeMaintainer = new NodeMaintainer();
        String sourceBipartiteType = null;
        String targetBipartiteType = null;
        if (requestBipartite) {
            sourceBipartiteType = sourceColumnName;
            targetBipartiteType = GraphContainer.separate(targetColumnNames, " OR ");
        }
        int numTotalRows = this.table.getRowCount();
        int numRowsProcessedSoFar = 0;
        if (this.progressMonitor != null) {
            this.progressMonitor.start(2, numTotalRows);
        }
        int recordsWithSkippedColumns = 0;
        IntIterator rows = this.table.rows();
        while (rows.hasNext()) {
            boolean rowHasSkippedColumns = false;
            int row = (Integer)rows.next();
            String sourceString = sourceColumn.getString(row);
            String targetString = GraphContainer.buildRowTargetStringFromColumnNames(row, targetColumnNames, this.table, delimiter);
            if (sourceString != null && targetString != null) {
                String[] sources = GraphContainer.splitIfDelimiterIsValid(sourceString, delimiter, splitPattern);
                Set cleanSourceNames = GraphContainer.clean(sources);
                String[] targets = GraphContainer.splitIfDelimiterIsValid(targetString, delimiter, splitPattern);
                Set cleanTargetNames = GraphContainer.clean(targets);
                Set updatedSources = this.updateNodes(nodeMaintainer, row, cleanSourceNames, sourceBipartiteType, 1);
                if (nodeMaintainer.hasSkippedColumns) {
                    rowHasSkippedColumns = true;
                    nodeMaintainer.hasSkippedColumns = false;
                }
                Set updatedTargets = this.updateNodes(nodeMaintainer, row, cleanTargetNames, targetBipartiteType, 2);
                if (nodeMaintainer.hasSkippedColumns) {
                    rowHasSkippedColumns = true;
                    nodeMaintainer.hasSkippedColumns = false;
                }
                for (Node updatedSource : updatedSources) {
                    for (Node updatedTarget : updatedTargets) {
                        EdgeContainer edgeContainer = new EdgeContainer();
                        edgeContainer.mutateEdge(updatedSource, updatedTarget, this.graph, this.table, row, this.edgeFunctionMap);
                        if (!edgeContainer.hasSkippedColumns) continue;
                        rowHasSkippedColumns = true;
                        edgeContainer.hasSkippedColumns = false;
                    }
                }
            }
            ++numRowsProcessedSoFar;
            if (this.progressMonitor != null) {
                this.progressMonitor.worked(numRowsProcessedSoFar);
            }
            if (!rowHasSkippedColumns) continue;
            ++recordsWithSkippedColumns;
        }
        Iterator dupIter = dupValuesErrorMessages.keySet().iterator();
        while (dupIter.hasNext()) {
            log.log(2, (String)dupValuesErrorMessages.get(dupIter.next()));
        }
        if (recordsWithSkippedColumns > 0) {
            log.log(2, String.valueOf(recordsWithSkippedColumns) + " records had empty values and were skipped.");
        }
        return this.graph;
    }

    private static String separate(Object[] array, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        if (array.length > 0) {
            buffer.append(array[0]);
            int ii = 1;
            while (ii < array.length) {
                buffer.append(delimiter);
                buffer.append(array[ii]);
                ++ii;
            }
        }
        return buffer.toString();
    }

    private Set updateNodes(NodeMaintainer nodeMaintainer, int rowIndex, Set cleanNames, String bipartiteType, int aggregateFunctionMappingType) {
        HashSet<Node> updatedNodes = new HashSet<Node>();
        for (String cleanName : cleanNames) {
            Node updatedNode = nodeMaintainer.mutateNode(cleanName, bipartiteType, this.graph, this.table, rowIndex, this.nodeFunctionMap, aggregateFunctionMappingType);
            updatedNodes.add(updatedNode);
        }
        return updatedNodes;
    }

    private static Set clean(String[] strings) {
        HashSet<String> cleanedStrings = new HashSet<String>();
        int ii = 0;
        while (ii < strings.length) {
            String rawString = strings[ii];
            String trimmedString = GraphContainer.normalizeLabel(rawString);
            if (!"".equals(trimmedString)) {
                cleanedStrings.add(trimmedString);
            }
            ++ii;
        }
        return cleanedStrings;
    }

    public static GraphContainer initializeGraph(Table inputTable, String sourceColumnName, String targetColumnName, boolean isDirected, Properties properties, LogService log) throws InvalidColumnNameException, PropertyParsingException {
        return GraphContainer.initializeGraph(inputTable, sourceColumnName, targetColumnName, isDirected, properties, log, null);
    }

    public static GraphContainer initializeGraph(Table inputTable, String sourceColumnName, String targetColumnName, boolean isDirected, Properties properties, LogService log, ProgressMonitor progressMonitor) throws InvalidColumnNameException, PropertyParsingException {
        Schema inputSchema = inputTable.getSchema();
        if (inputSchema.getColumnIndex(sourceColumnName) < 0) {
            throw new InvalidColumnNameException(String.valueOf(sourceColumnName) + " was not a column in this table.\n");
        }
        String[] targetColumnNameArray = targetColumnName.split("\\,");
        if (targetColumnNameArray == null || targetColumnNameArray.length == 0) {
            throw new InvalidColumnNameException(String.valueOf(targetColumnName) + " was not a column in this table.\n");
        }
        String[] stringArray = targetColumnNameArray;
        int n = targetColumnNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            if (inputSchema.getColumnIndex(columnName) < 0) {
                throw new InvalidColumnNameException(String.valueOf(columnName) + " was not a column in this table.\n");
            }
            ++n2;
        }
        Schema nodeSchema = GraphContainer.createNodeSchema();
        Schema edgeSchema = GraphContainer.createEdgeSchema();
        AggregateFunctionMappings nodeAggregateFunctionMap = new AggregateFunctionMappings();
        AggregateFunctionMappings edgeAggregateFunctionMap = new AggregateFunctionMappings();
        try {
            AggregateFunctionMappings.parseProperties(inputSchema, nodeSchema, edgeSchema, properties, nodeAggregateFunctionMap, edgeAggregateFunctionMap, log);
        }
        catch (AggregateFunctionMappings.CompatibleAggregationNotFoundException e) {
            throw new PropertyParsingException(e);
        }
        if (GraphContainer.isPerformingCooccurrenceExtraction(sourceColumnName, targetColumnName) && edgeSchema.getColumnIndex("weight") == -1) {
            try {
                AggregateFunctionMappings.addDefaultEdgeWeightColumn(inputSchema, edgeSchema, edgeAggregateFunctionMap, sourceColumnName);
            }
            catch (AggregateFunctionMappings.CompatibleAggregationNotFoundException e) {
                throw new PropertyParsingException(e);
            }
        }
        Graph outputGraph = new Graph(nodeSchema.instantiate(), edgeSchema.instantiate(), isDirected);
        return new GraphContainer(outputGraph, inputTable, nodeAggregateFunctionMap, edgeAggregateFunctionMap, progressMonitor);
    }

    private static boolean isPerformingCooccurrenceExtraction(String sourceColumnName, String targetColumnName) {
        return sourceColumnName.equals(targetColumnName);
    }

    private static Schema createNodeSchema() {
        Schema nodeSchema = new Schema();
        nodeSchema.addColumn(LABEL_COLUMN_NAME, String.class);
        return nodeSchema;
    }

    private static Schema createEdgeSchema() {
        Schema edgeSchema = new Schema();
        edgeSchema.addColumn(SOURCE_COLUMN_NAME, Integer.TYPE);
        edgeSchema.addColumn(TARGET_COLUMN_NAME, Integer.TYPE);
        return edgeSchema;
    }

    private static String buildRowTargetStringFromColumnNames(int row, String[] targetColumnNames, Table table, String delimiter) {
        String targetString = "";
        Column targetColumn = table.getColumn(targetColumnNames[0]);
        targetString = String.valueOf(targetString) + targetColumn.getString(row);
        int iColumn = 1;
        while (iColumn < targetColumnNames.length) {
            targetColumn = table.getColumn(targetColumnNames[iColumn]);
            targetString = String.valueOf(targetString) + delimiter;
            targetString = String.valueOf(targetString) + targetColumn.getString(row);
            ++iColumn;
        }
        return targetString;
    }

    private static String[] splitIfDelimiterIsValid(String toSplit, String delimiter, Pattern splitPattern) {
        if (!StringUtilities.isNull_Empty_OrWhitespace((String)delimiter)) {
            return splitPattern.split(toSplit);
        }
        return new String[]{toSplit};
    }

    public static class PropertyParsingException
    extends Exception {
        private static final long serialVersionUID = 814116449021611862L;

        public PropertyParsingException() {
        }

        public PropertyParsingException(String message) {
            super(message);
        }

        public PropertyParsingException(Throwable cause) {
            super(cause);
        }

        public PropertyParsingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

