/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.components;

import edu.iu.nwb.analysis.extractnetfromtable.components.AggregateFunctionMappings;
import edu.iu.nwb.analysis.extractnetfromtable.components.FunctionContainer;
import edu.iu.nwb.analysis.extractnetfromtable.components.NodeID;
import edu.iu.nwb.analysis.extractnetfromtable.components.ValueAttributes;
import org.cishell.utilities.TableUtilities;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;

public class NodeMaintainer {
    public static final String BIPARTITE_TYPE_SUGGESTED_COLUMN_NAME = "bipartiteType";
    private String bipartiteTypeColumnName = null;
    boolean hasSkippedColumns = false;

    protected Node createNode(String label, String bipartiteType, Graph graph, Table table, int rowNumber, AggregateFunctionMappings nodeFunctionMappings, int nodeType) {
        int nodeNumber = graph.addNodeRow();
        Node n = graph.getNode(nodeNumber);
        n.set("label", (Object)label);
        if (bipartiteType != null) {
            if (this.bipartiteTypeColumnName == null) {
                this.bipartiteTypeColumnName = TableUtilities.formNonConflictingNewColumnName((Schema)graph.getNodeTable().getSchema(), (String)BIPARTITE_TYPE_SUGGESTED_COLUMN_NAME);
                graph.getNodeTable().addColumn(this.bipartiteTypeColumnName, String.class);
            }
            n.set(this.bipartiteTypeColumnName, (Object)bipartiteType);
        }
        ValueAttributes va = new ValueAttributes(nodeNumber);
        FunctionContainer functionContainer = new FunctionContainer();
        va = functionContainer.mutateFunctions((Tuple)n, table, rowNumber, va, nodeFunctionMappings, nodeType);
        if (functionContainer.hasSkippedColumns) {
            this.hasSkippedColumns = true;
        }
        nodeFunctionMappings.addFunctionRow(new NodeID(label, bipartiteType), va);
        return n;
    }

    protected Node mutateNode(String tableValue, String bipartiteType, Graph graph, Table table, int rowNumber, AggregateFunctionMappings afm, int nodeType) {
        Node n;
        ValueAttributes va = afm.getFunctionRow(new NodeID(tableValue, bipartiteType));
        if (va == null) {
            n = this.createNode(tableValue, bipartiteType, graph, table, rowNumber, afm, nodeType);
        } else {
            int nodeNumber = va.getRowNumber();
            n = graph.getNode(nodeNumber);
            FunctionContainer functionContainer = new FunctionContainer();
            functionContainer.mutateFunctions((Tuple)n, table, rowNumber, va, afm, nodeType);
            if (functionContainer.hasSkippedColumns) {
                this.hasSkippedColumns = true;
            }
        }
        return n;
    }
}

