/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.extractnetfromtable.components;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.osgi.service.log.LogService;

public class PropertyHandler {
    public static boolean validateProperties(FileInputStream fis) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        boolean wellFormed = true;
        Pattern p = Pattern.compile("^.*\\..*=.*\\..*");
        while ((line = br.readLine()) != null) {
            Matcher m;
            if (!line.startsWith("node.") && !line.startsWith("edge.") || (m = p.matcher(line.subSequence(0, line.length())).reset()).find()) continue;
            wellFormed = false;
        }
        br.close();
        return wellFormed;
    }

    public static Properties getProperties(String fileName, LogService log) throws AlgorithmExecutionException {
        Properties aggregateDefs = new Properties();
        boolean wellFormed = true;
        try {
            File f = new File(fileName);
            FileInputStream in = new FileInputStream(f);
            wellFormed = PropertyHandler.validateProperties(in);
            if (wellFormed) {
                in = new FileInputStream(f);
                aggregateDefs.load(in);
            } else {
                log.log(2, "Your Aggregate Function File did not follow the specified format.\nContinuing the extraction without additional analysis.");
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new AlgorithmExecutionException(fnfe.getMessage(), (Throwable)fnfe);
        }
        catch (IOException ie) {
            throw new AlgorithmExecutionException(ie.getMessage(), (Throwable)ie);
        }
        return aggregateDefs;
    }
}

