/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.hits;

import edu.iu.nwb.analysis.hits.HITSAlgorithmOutputGenerator;
import edu.iu.nwb.analysis.hits.HITSComputation;
import edu.iu.nwb.converter.nwb.common.ValidateNWBFile;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class HITSAlgorithm
implements Algorithm {
    private Data[] data;
    private Dictionary parameters;
    private CIShellContext context;
    private LogService logger;
    private static int DEFAULT_NUMBER_OF_ITERATIONS = 20;
    private int numberOfIterations = DEFAULT_NUMBER_OF_ITERATIONS;

    public HITSAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File inputData = (File)this.data[0].getData();
        int numberOfNodes = 0;
        try {
            numberOfNodes = HITSAlgorithm.validateInputFile(inputData);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException("Inappropriate NWB File provided.", (Throwable)e);
        }
        if (numberOfNodes > 0) {
            try {
                this.numberOfIterations = (Integer)this.parameters.get("iterations");
                String edgeWeightColumnName = (String)this.parameters.get("weightcolumn");
                if (this.numberOfIterations <= 0) {
                    this.logger.log(2, "Number of Iterations should be more than 0. Default value of \"Number of Iterations\" (20) used.");
                    this.numberOfIterations = DEFAULT_NUMBER_OF_ITERATIONS;
                }
                NWBFileParser parser = new NWBFileParser(inputData);
                HITSComputation hitsComputation = new HITSComputation(numberOfNodes, this.numberOfIterations, edgeWeightColumnName);
                parser.parse((NWBFileParserHandler)hitsComputation);
                File outputNWBFile = File.createTempFile("hits-", ".nwb");
                NWBFileParser outputParser = new NWBFileParser(inputData);
                outputParser.parse((NWBFileParserHandler)new HITSAlgorithmOutputGenerator(hitsComputation, outputNWBFile));
                BasicData outNWBData = new BasicData((Object)outputNWBFile, "file:text/nwb");
                outNWBData.getMetadata().put("Label", "HITS on network with " + numberOfNodes + " nodes. Authority & Hubs updated " + this.numberOfIterations + " times.");
                outNWBData.getMetadata().put("Type", "Network");
                outNWBData.getMetadata().put("Parent", this.data[0]);
                return new Data[]{outNWBData};
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new AlgorithmExecutionException("NWB File'" + inputData.getAbsolutePath() + "' not found.");
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
            catch (ParsingException e) {
                throw new AlgorithmExecutionException((Throwable)e);
            }
        }
        return this.data;
    }

    private static int validateInputFile(File inData) throws ParsingException, AlgorithmExecutionException {
        ValidateNWBFile validateParser = new ValidateNWBFile();
        try {
            validateParser.validateNWBFormat(inData);
            return validateParser.getTotalNumOfNodes();
        }
        catch (Exception exception) {
            throw new AlgorithmExecutionException("Inappropriate NWB File provided.");
        }
    }
}

