/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.hits;

import cern.colt.matrix.DoubleMatrix2D;
import edu.iu.nwb.analysis.hits.HITSComputation;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HITSAlgorithmOutputGenerator
implements NWBFileParserHandler {
    private NWBFileWriter output;
    private NWBFileParser parser;
    private File edgeFile;
    private DoubleMatrix2D authorityMatrix;
    private DoubleMatrix2D hubMatrix;
    private HashMap nodeIDToMatrixIndexMap;

    public HITSAlgorithmOutputGenerator(HITSComputation hitsComputation, File outputNWBFile) throws IOException {
        this.output = new NWBFileWriter(outputNWBFile);
        this.authorityMatrix = hitsComputation.authorityMatrix;
        this.hubMatrix = hitsComputation.hubMatrix;
        this.nodeIDToMatrixIndexMap = hitsComputation.nodeIDToMatrixIndexMap;
    }

    public void setNodeCount(int numberOfNodes) {
        this.output.setNodeCount(numberOfNodes);
    }

    public void setNodeSchema(LinkedHashMap schema) {
        schema.put("authority_score", "float");
        schema.put("hub_score", "float");
        this.output.setNodeSchema(schema);
    }

    public void addNode(int id, String label, Map attributes) {
        float hubScore;
        float authorityScore;
        int matrixIndexToBeExtracted = (Integer)((List)this.nodeIDToMatrixIndexMap.get(id)).toArray()[0];
        try {
            authorityScore = (float)this.authorityMatrix.get(matrixIndexToBeExtracted, 0);
        }
        catch (Exception exception) {
            authorityScore = new Float(0.0f).floatValue();
        }
        try {
            hubScore = (float)this.hubMatrix.get(matrixIndexToBeExtracted, 0);
        }
        catch (Exception exception) {
            hubScore = new Float(0.0f).floatValue();
        }
        attributes.put("authority_score", Float.valueOf(authorityScore));
        attributes.put("hub_score", Float.valueOf(hubScore));
        this.output.addNode(id, label, attributes);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
        this.output.addDirectedEdge(sourceNode, targetNode, attributes);
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
        this.output.addUndirectedEdge(node1, node2, attributes);
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
        this.output.setDirectedEdgeCount(numberOfEdges);
    }

    public void setDirectedEdgeSchema(LinkedHashMap schema) {
        this.output.setDirectedEdgeSchema(schema);
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
        this.output.setUndirectedEdgeCount(numberOfEdges);
    }

    public void setUndirectedEdgeSchema(LinkedHashMap schema) {
        this.output.setUndirectedEdgeSchema(schema);
    }

    public void addComment(String comment) {
        this.output.addComment(comment);
    }

    public void finishedParsing() {
        this.output.finishedParsing();
    }

    public boolean haltParsingNow() {
        return false;
    }
}

