/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.hits;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HITSComputation
implements NWBFileParserHandler {
    private static final double DEFAULT_EDGE_WEIGHT = 1.0;
    private boolean wantDense = false;
    private DoubleFactory2D matrixFactory;
    public DoubleMatrix2D adjacencyMatrix;
    public DoubleMatrix2D adjacencyTransposeMatrix;
    public DoubleMatrix2D authorityMatrix;
    public DoubleMatrix2D hubMatrix;
    public HashMap nodeIDToMatrixIndexMap = new HashMap();
    private String edgeWeightColumnName;
    private int numberOfNodes;
    private int numberOfIterations;
    private int nodeCountForMatrix = 0;
    private Functions matrixMultiplicationFunctions = Functions.functions;

    public HITSComputation(int numberOfNodes, int numberOfIterations, String edgeWeightColumnName) {
        this.numberOfNodes = numberOfNodes;
        this.numberOfIterations = numberOfIterations;
        this.edgeWeightColumnName = edgeWeightColumnName;
        this.initializeHITSComputationMatrices(numberOfNodes);
    }

    private void updateAuthorityHubMatrices(int numberOfIterations) {
        Double hubSum = 0.0;
        while (numberOfIterations-- > 0) {
            this.adjacencyTransposeMatrix.zMult(this.hubMatrix, this.authorityMatrix);
            this.adjacencyMatrix.zMult(this.authorityMatrix, this.hubMatrix);
            Double authoritySum = this.authorityMatrix.zSum();
            this.authorityMatrix.assign(Functions.div((double)authoritySum));
            hubSum = this.hubMatrix.zSum();
            this.hubMatrix.assign(Functions.div((double)hubSum));
        }
    }

    private void initializeHITSComputationMatrices(int adjacencyMatrixDimension) {
        this.matrixFactory = this.wantDense ? DoubleFactory2D.dense : DoubleFactory2D.sparse;
        this.adjacencyMatrix = this.matrixFactory.make(adjacencyMatrixDimension, adjacencyMatrixDimension);
        this.authorityMatrix = this.matrixFactory.make(adjacencyMatrixDimension, 1);
        this.hubMatrix = this.matrixFactory.make(adjacencyMatrixDimension, 1);
        this.authorityMatrix.assign(1.0);
        this.hubMatrix.assign(1.0);
    }

    private void setAdjacencyMatrixElements(int node1, int node2, Map attributes, boolean isUnDirectedEdge) {
        double edgeWeight;
        int sourceEdge = (Integer)((List)this.nodeIDToMatrixIndexMap.get(node1)).toArray()[0];
        int destinationEdge = (Integer)((List)this.nodeIDToMatrixIndexMap.get(node2)).toArray()[0];
        try {
            edgeWeight = Double.parseDouble(attributes.get(this.edgeWeightColumnName).toString());
        }
        catch (Exception exception) {
            edgeWeight = 1.0;
        }
        this.adjacencyMatrix.set(sourceEdge, destinationEdge, edgeWeight);
        if (isUnDirectedEdge) {
            this.adjacencyMatrix.set(destinationEdge, sourceEdge, edgeWeight);
        }
    }

    public void addComment(String comment) {
    }

    public void addNode(int id, String label, Map attributes) {
        ArrayList<Object> nodeAttributes = new ArrayList<Object>();
        nodeAttributes.add(this.nodeCountForMatrix);
        nodeAttributes.add(attributes);
        this.nodeIDToMatrixIndexMap.put(id, nodeAttributes);
        ++this.nodeCountForMatrix;
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map attributes) {
        this.setAdjacencyMatrixElements(sourceNode, targetNode, attributes, false);
    }

    public void addUndirectedEdge(int node1, int node2, Map attributes) {
        this.setAdjacencyMatrixElements(node1, node2, attributes, true);
    }

    public void finishedParsing() {
        this.adjacencyTransposeMatrix = this.adjacencyMatrix.viewDice();
        this.updateAuthorityHubMatrices(this.numberOfIterations);
    }

    public boolean haltParsingNow() {
        return false;
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
    }

    public void setDirectedEdgeSchema(LinkedHashMap schema) {
    }

    public void setNodeCount(int numberOfNodes) {
    }

    public void setNodeSchema(LinkedHashMap schema) {
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
    }

    public void setUndirectedEdgeSchema(LinkedHashMap schema) {
    }
}

