/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.isidupremover;

import java.util.Iterator;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.util.Sort;

public class GraphUtil {
    public static String[] getColumnNames(Table t) {
        String[] columnNames = new String[t.getColumnCount()];
        int ii = 0;
        while (ii < t.getColumnCount()) {
            columnNames[ii] = t.getColumnName(ii);
            ++ii;
        }
        return columnNames;
    }

    public static Table copyTable(Table t) {
        Table tCopy = new Table();
        tCopy.addColumns(t.getSchema());
        Iterator ii = t.tuples();
        while (ii.hasNext()) {
            Tuple tuple = (Tuple)ii.next();
            tCopy.addTuple(tuple);
        }
        return tCopy;
    }

    public static void printTable(Table t) {
        Iterator ii = t.tuples();
        while (ii.hasNext()) {
            System.out.println((Tuple)ii.next());
        }
    }

    public static Table getSorted(Table t) {
        return GraphUtil.getSortedByColumns(t, GraphUtil.getColumnNames(t));
    }

    public static Table getSortedByColumns(Table t, String[] columnNames) {
        int ii = 0;
        while (ii < columnNames.length) {
            String columnName = columnNames[ii];
            if (t.getColumn(columnName) == null) {
                System.out.println("Cannot find column " + columnName);
            }
            ++ii;
        }
        Sort tSort = new Sort(columnNames);
        Table sortedTable = t.select(ExpressionParser.predicate((String)"TRUE"), tSort);
        return sortedTable;
    }

    public static boolean areEqual(Tuple tu1, Tuple tu2) {
        if (tu1.getColumnCount() != tu2.getColumnCount()) {
            return false;
        }
        int ii = 0;
        while (ii < tu1.getColumnCount()) {
            Object columnContents1 = tu1.get(ii);
            Object columnContents2 = null;
            boolean foundMatchingColumn = false;
            int kk = 0;
            while (kk < tu2.getColumnCount()) {
                if (tu2.getColumnName(kk).equals(tu1.getColumnName(ii))) {
                    columnContents2 = tu2.get(kk);
                    foundMatchingColumn = true;
                    break;
                }
                ++kk;
            }
            if (!foundMatchingColumn) {
                return false;
            }
            tu1.getColumnName(ii);
            if (columnContents1 != null || columnContents2 != null) {
                if (columnContents1 == null) {
                    return false;
                }
                if (columnContents2 == null) {
                    return false;
                }
                if (!columnContents1.equals(columnContents2)) {
                    return false;
                }
            }
            ++ii;
        }
        return true;
    }
}

