/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.isidupremover;

import edu.iu.nwb.analysis.isidupremover.ISIDupRemover;
import edu.iu.nwb.analysis.isidupremover.TablePair;
import java.util.Dictionary;
import java.util.Enumeration;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Table;

public class ISIDupRemoverAlgorithm
implements Algorithm {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;
    private LogService log;
    private ISIDupRemover dupRemover;

    public ISIDupRemoverAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.log = (LogService)context.getService(LogService.class.getName());
        this.dupRemover = new ISIDupRemover();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table tableWithDups = (Table)this.data[0].getData();
        TablePair dupAndNoDupTables = this.dupRemover.removeDuplicatePublications(tableWithDups, this.log, false);
        Table tableWithoutDups = dupAndNoDupTables.getNoDupTable();
        dupAndNoDupTables.getDupTable();
        BasicData tableWithoutDupsData = new BasicData((Object)tableWithoutDups, tableWithoutDups.getClass().getName());
        this.copyOverMetaData(this.data[0], (Data)tableWithoutDupsData);
        Dictionary dupRemovedMetaData = tableWithoutDupsData.getMetadata();
        dupRemovedMetaData.put("Parent", this.data[0]);
        dupRemovedMetaData.put("Label", String.valueOf(tableWithoutDups.getRowCount()) + " Unique ISI Records");
        return new Data[]{tableWithoutDupsData};
    }

    private void copyOverMetaData(Data sourceData, Data targetData) {
        Dictionary sourceMetaData = sourceData.getMetadata();
        Dictionary targetMetaData = targetData.getMetadata();
        Enumeration keyEnum = sourceMetaData.keys();
        while (keyEnum.hasMoreElements()) {
            Object key = keyEnum.nextElement();
            targetMetaData.put(key, sourceMetaData.get(key));
        }
    }
}

