/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.java.nodedegree.components;

import edu.iu.nwb.analysis.java.nodedegree.components.NodeDegreeAnnotator;
import prefuse.data.Graph;
import prefuse.data.Table;

public class NodeAnnotationThread
extends Thread {
    private final Graph originalGraph;
    private Graph targetGraph;
    private int start;
    private int end;
    private NodeDegreeAnnotator na;

    public NodeAnnotationThread(Graph orgGraph, Graph targetGraph, int start, int end, NodeDegreeAnnotator na) {
        this.originalGraph = orgGraph;
        this.targetGraph = targetGraph;
        this.start = start;
        this.end = end;
        this.na = na;
    }

    @Override
    public void run() {
        super.run();
        int degreeType = this.na.getDegreeType();
        String label = null;
        if (degreeType == 1) {
            label = "inDegree";
        }
        if (degreeType == 2) {
            label = "outDegree";
        }
        if (degreeType == 0) {
            label = "totalDegree";
        }
        Table sourceNodeTable = this.originalGraph.getNodeTable();
        Table targetNodeTable = this.targetGraph.getNodeTable();
        int tenPercent = (int)Math.ceil((this.end - this.start) / 10);
        if (tenPercent == 0) {
            tenPercent = 1;
        }
        int counter = 1;
        int i = this.start;
        while (i < this.end) {
            if (counter % tenPercent == 0) {
                NodeDegreeAnnotator.updateProgress(this.na, counter);
            }
            int j = 0;
            while (j < sourceNodeTable.getColumnCount()) {
                targetNodeTable.set(i, j, sourceNodeTable.get(i, j));
                ++j;
            }
            if (degreeType == 0) {
                targetNodeTable.setInt(i, label, this.originalGraph.getDegree(i));
            } else if (degreeType == 1) {
                targetNodeTable.setInt(i, label, this.originalGraph.getInDegree(i));
            } else if (degreeType == 2) {
                targetNodeTable.setInt(i, label, this.originalGraph.getOutDegree(i));
            }
            ++counter;
            ++i;
        }
    }
}

