/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.java.nodedegree.components;

import edu.iu.nwb.analysis.java.nodedegree.components.NodeAnnotationThread;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.ProgressMonitor;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Table;

public class NodeDegreeAnnotator {
    private ProgressMonitor progMonitor;
    private int progress = 0;
    private int degreeType;

    public NodeDegreeAnnotator(ProgressMonitor pm, int degreeType) {
        this.progMonitor = pm;
        this.degreeType = degreeType;
    }

    public Graph annotateGraph(Graph orgGraph, Graph targetGraph) throws InterruptedException {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        NodeDegreeAnnotator.updateProgress(this, orgGraph.getNodeCount());
        Thread[] pool = new Thread[numProcessors];
        int nodesPerThread = orgGraph.getNodeCount() / numProcessors;
        int remainingNodes = orgGraph.getNodeCount() - nodesPerThread * numProcessors;
        int i = 0;
        while (i < numProcessors) {
            int start = i * nodesPerThread;
            int end = (i + 1) * nodesPerThread;
            if (i == numProcessors - 1) {
                end += remainingNodes;
            }
            pool[i] = new NodeAnnotationThread(orgGraph, targetGraph, start, end, this);
            pool[i].start();
            ++i;
        }
        NodeDegreeAnnotator.copyEdges(orgGraph, targetGraph);
        i = 0;
        while (i < numProcessors) {
            pool[i].join();
            ++i;
        }
        return targetGraph;
    }

    public static void copyEdges(Graph source, Graph target) {
        Table sourceEdgeTable = source.getEdgeTable();
        Table targetEdgeTable = target.getEdgeTable();
        int i = 0;
        while (i < sourceEdgeTable.getRowCount()) {
            int j = 0;
            while (j < sourceEdgeTable.getColumnCount()) {
                targetEdgeTable.set(i, j, sourceEdgeTable.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public static void updateProgress(NodeDegreeAnnotator na, int work) {
        na.progress += work;
        na.progMonitor.worked(na.progress);
    }

    public Graph createAnnotatedGraph(Graph originalGraph) throws AlgorithmExecutionException {
        Schema originalGraphNodeSchema = originalGraph.getNodeTable().getSchema();
        Schema originalGraphEdgeSchema = originalGraph.getEdgeTable().getSchema();
        Schema annotatedGraphNodeSchema = NodeDegreeAnnotator.copySchema(originalGraphNodeSchema);
        if (annotatedGraphNodeSchema == null) {
            if (this.degreeType == 0) {
                NodeDegreeAnnotator.throwException("totalDegree");
            }
            if (this.degreeType == 1) {
                NodeDegreeAnnotator.throwException("inDegree");
            }
            if (this.degreeType == 2) {
                NodeDegreeAnnotator.throwException("outDegree");
            }
        }
        annotatedGraphNodeSchema = this.appendDegreeAnnotation(annotatedGraphNodeSchema, this.degreeType);
        Schema annotatedGraphEdgeSchema = NodeDegreeAnnotator.copySchema(originalGraphEdgeSchema);
        Table newNodeTable = annotatedGraphNodeSchema.instantiate(originalGraph.getNodeTable().getRowCount());
        Table newEdgeTable = annotatedGraphEdgeSchema.instantiate(originalGraph.getEdgeTable().getRowCount());
        Graph annotatedGraph = new Graph(newNodeTable, newEdgeTable, originalGraph.isDirected());
        return annotatedGraph;
    }

    private static Schema copySchema(Schema original) {
        Schema copy = new Schema();
        int i = 0;
        while (i < original.getColumnCount()) {
            copy.addColumn(original.getColumnName(i), original.getColumnType(i));
            ++i;
        }
        return copy;
    }

    private Schema appendDegreeAnnotation(Schema targetSchema, int degreeType) throws AlgorithmExecutionException {
        int index = -1;
        String label = null;
        if (degreeType == 0) {
            index = targetSchema.getColumnIndex("totalDegree");
            label = "totalDegree";
        }
        if (degreeType == 1) {
            index = targetSchema.getColumnIndex("inDegree");
            label = "inDegree";
        }
        if (degreeType == 2) {
            index = targetSchema.getColumnIndex("outDegree");
            label = "outDegree";
        }
        if (index < 0) {
            if (degreeType == 0) {
                targetSchema.addColumn("totalDegree", Integer.TYPE);
            }
            if (degreeType == 1) {
                targetSchema.addColumn("inDegree", Integer.TYPE);
            }
            if (degreeType == 2) {
                targetSchema.addColumn("outDegree", Integer.TYPE);
            }
        } else {
            throw new AlgorithmExecutionException("This graph already has an attribute named " + label + ". Rename this attribute if you wish to continue.");
        }
        return targetSchema;
    }

    private static void throwException(String type) throws AlgorithmExecutionException {
        throw new AlgorithmExecutionException("Attribute: " + type + " already exists. Please rename the attribute before rerunning this algorithm.");
    }

    public int getDegreeType() {
        return this.degreeType;
    }
}

