/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.java.nodeindegree;

import edu.iu.nwb.analysis.java.nodedegree.components.NodeDegreeAnnotator;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.algorithm.ProgressTrackable;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Graph;

public class NodeIndegree
implements Algorithm,
ProgressTrackable {
    private Data[] data;
    private Dictionary parameters;
    private CIShellContext context;
    private ProgressMonitor monitor;
    private LogService logger;

    public NodeIndegree(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Graph originalGraph = (Graph)this.data[0].getData();
        NodeDegreeAnnotator nodeAnnotator = new NodeDegreeAnnotator(this.getProgressMonitor(), 1);
        Graph annotatedGraph = nodeAnnotator.createAnnotatedGraph(originalGraph);
        try {
            this.monitor.start(2, 2 * originalGraph.getNodeCount());
            nodeAnnotator.annotateGraph(originalGraph, annotatedGraph);
        }
        catch (InterruptedException e) {
            throw new AlgorithmExecutionException("Execution was unexpectedly interrupted.", (Throwable)e);
        }
        Data returnData = NodeIndegree.constructData(this.data[0], annotatedGraph, Graph.class.toString(), "Network", "Network with indegree attribute added to node list");
        this.monitor.done();
        return new Data[]{returnData};
    }

    private static Data constructData(Data parent, Object obj, String className, String type, String label) {
        BasicData outputData = new BasicData(obj, className);
        Dictionary dataAttributes = outputData.getMetadata();
        dataAttributes.put("Modified", new Boolean(true));
        dataAttributes.put("Parent", parent);
        dataAttributes.put("Type", type);
        dataAttributes.put("Label", label);
        return outputData;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

