/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.java.strongcomponentclustering.components;

import java.util.Iterator;
import java.util.Stack;
import org.cishell.framework.algorithm.ProgressMonitor;
import prefuse.data.CascadedTable;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;

public class AnnotateStrongComponents {
    ProgressMonitor progMonitor;
    int progress = 0;
    private int strongComponentClusters;
    private static final String preOrderColumn = "preOrder";
    private static final String strongComponentColumn = "strongComponentID";

    public AnnotateStrongComponents(ProgressMonitor pm) {
        this.progMonitor = pm;
    }

    public Graph strongComponentCalculation(Graph sourceGraph) {
        int nodeCount = sourceGraph.getNodeTable().getRowCount();
        Stack firstStack = new Stack();
        firstStack.setSize(nodeCount);
        Stack secondStack = new Stack();
        secondStack.setSize(nodeCount);
        Graph targetGraph = AnnotateStrongComponents.createTargetGraph(sourceGraph);
        CascadedTable ct = new CascadedTable(sourceGraph.getNodeTable());
        ct.addColumn(strongComponentColumn, Integer.TYPE, (Object)new Integer(-1));
        ct.addColumn(preOrderColumn, Integer.TYPE, (Object)new Integer(-1));
        this.strongComponentClusters = 0;
        Integer testCount = new Integer(0);
        int v = nodeCount - 1;
        while (v >= 0) {
            Node n;
            if (ct.getInt(v, preOrderColumn) == -1 && (n = sourceGraph.getNode(v)).getString("label") != null) {
                AnnotateStrongComponents.copyTuple(sourceGraph.getNodeTable(), targetGraph.getNodeTable(), v);
                this.recursiveStrongComponentCalculation(sourceGraph, targetGraph, n, ct, firstStack, secondStack, testCount);
            }
            --v;
        }
        return targetGraph;
    }

    private void recursiveStrongComponentCalculation(Graph sourceGraph, Graph targetGraph, Node n, CascadedTable ct, Stack firstStack, Stack secondStack, Integer count) {
        int v;
        count = new Integer(count + 1);
        ct.setInt(n.getRow(), preOrderColumn, count.intValue());
        firstStack.push(new Integer(n.getRow()));
        secondStack.push(new Integer(n.getRow()));
        Iterator it = n.outNeighbors();
        while (it.hasNext()) {
            int outNode = ((Node)it.next()).getRow();
            int edgeRow = sourceGraph.getEdge(n.getRow(), outNode);
            AnnotateStrongComponents.copyTuple(sourceGraph.getEdgeTable(), targetGraph.getEdgeTable(), edgeRow);
            if (ct.getInt(outNode, preOrderColumn) == -1) {
                AnnotateStrongComponents.copyTuple(sourceGraph.getNodeTable(), targetGraph.getNodeTable(), outNode);
                this.recursiveStrongComponentCalculation(sourceGraph, targetGraph, sourceGraph.getNode(outNode), ct, firstStack, secondStack, count);
                continue;
            }
            if (ct.getInt(outNode, strongComponentColumn) != -1) continue;
            while (ct.getInt(((Integer)secondStack.peek()).intValue(), preOrderColumn) > ct.getInt(outNode, preOrderColumn)) {
                secondStack.pop();
            }
        }
        if (((Integer)secondStack.peek()).intValue() != n.getRow()) {
            return;
        }
        secondStack.pop();
        do {
            v = (Integer)firstStack.pop();
            ct.setInt(v, strongComponentColumn, this.strongComponentClusters);
            targetGraph.getNode(v).setInt(strongComponentColumn, this.strongComponentClusters);
        } while (n.getRow() != v);
        ++this.strongComponentClusters;
    }

    private static Graph createTargetGraph(Graph originalGraph) {
        Schema originalNodeSchema = originalGraph.getNodeTable().getSchema();
        Schema originalEdgeSchema = originalGraph.getEdgeTable().getSchema();
        Schema targetNodeSchema = AnnotateStrongComponents.copySchema(originalNodeSchema);
        targetNodeSchema.addColumn(strongComponentColumn, Integer.TYPE);
        Schema targetEdgeSchema = AnnotateStrongComponents.copySchema(originalEdgeSchema);
        return new Graph(targetNodeSchema.instantiate(originalGraph.getNodeCount()), targetEdgeSchema.instantiate(originalGraph.getEdgeCount()), originalGraph.isDirected());
    }

    private static Schema copySchema(Schema sourceSchema) {
        Schema copy = new Schema();
        int i = 0;
        while (i < sourceSchema.getColumnCount()) {
            copy.addColumn(sourceSchema.getColumnName(i), sourceSchema.getColumnType(i));
            ++i;
        }
        return copy;
    }

    private static void copyTuple(Table sourceTable, Table targetTable, int rowNumber) {
        int i = 0;
        while (i < sourceTable.getColumnCount()) {
            targetTable.set(rowNumber, i, sourceTable.get(rowNumber, i));
            ++i;
        }
    }

    public static void updateProgress(AnnotateStrongComponents asc, int progress) {
        asc.progress += progress;
        asc.progMonitor.worked(asc.progress);
    }
}

