/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.java.undirectedknn.components;

import edu.iu.nwb.analysis.java.undirectedknn.components.KNNCalculatorThread;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.ProgressMonitor;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Table;

public class KNNCalculator {
    private ProgressMonitor progMonitor;
    private int progress = 0;

    public KNNCalculator(ProgressMonitor pm) {
        this.progMonitor = pm;
    }

    public Graph calculateKNN(Graph originalGraph, Graph targetGraph, File statisticFile) throws InterruptedException, AlgorithmExecutionException {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        Map degreeToSumOfNeighborsDegree = Collections.synchronizedMap(new HashMap());
        Map degreeToTotalNumberOfDegree = Collections.synchronizedMap(new HashMap());
        KNNCalculator.updateProgress(this, originalGraph.getNodeCount());
        Thread[] pool = new Thread[numProcessors];
        int nodesPerThread = originalGraph.getNodeCount() / numProcessors;
        int remainingNodes = originalGraph.getNodeCount() - nodesPerThread * numProcessors;
        int i = 0;
        while (i < numProcessors) {
            int start = i * nodesPerThread;
            int end = (i + 1) * nodesPerThread;
            if (i == numProcessors - 1) {
                end += remainingNodes;
            }
            pool[i] = new KNNCalculatorThread(originalGraph, targetGraph, start, end, this, degreeToSumOfNeighborsDegree, degreeToTotalNumberOfDegree);
            pool[i].start();
            ++i;
        }
        KNNCalculator.copyEdges(originalGraph, targetGraph);
        i = 0;
        while (i < numProcessors) {
            pool[i].join();
            ++i;
        }
        KNNCalculator.writeDegreeDegreeCorrelations(degreeToSumOfNeighborsDegree, degreeToTotalNumberOfDegree, statisticFile, originalGraph.getNodeCount());
        return targetGraph;
    }

    public Graph createAnnotatedGraph(Graph originalGraph) throws AlgorithmExecutionException {
        Schema originalGraphNodeSchema = originalGraph.getNodeTable().getSchema();
        Schema originalGraphEdgeSchema = originalGraph.getEdgeTable().getSchema();
        Schema annotatedGraphNodeSchema = KNNCalculator.copySchema(originalGraphNodeSchema);
        annotatedGraphNodeSchema = KNNCalculator.appendKNNColumn(annotatedGraphNodeSchema);
        Schema annotatedGraphEdgeSchema = KNNCalculator.copySchema(originalGraphEdgeSchema);
        Table newNodeTable = annotatedGraphNodeSchema.instantiate(originalGraph.getNodeTable().getRowCount());
        Table newEdgeTable = annotatedGraphEdgeSchema.instantiate(originalGraph.getEdgeTable().getRowCount());
        Graph annotatedGraph = new Graph(newNodeTable, newEdgeTable, originalGraph.isDirected());
        return annotatedGraph;
    }

    public static void copyEdges(Graph source, Graph target) {
        Table sourceEdgeTable = source.getEdgeTable();
        Table targetEdgeTable = target.getEdgeTable();
        int i = 0;
        while (i < sourceEdgeTable.getRowCount()) {
            int j = 0;
            while (j < sourceEdgeTable.getColumnCount()) {
                targetEdgeTable.set(i, j, sourceEdgeTable.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public static void updateProgress(KNNCalculator kc, int work) {
        kc.progress += work;
        kc.progMonitor.worked(kc.progress);
    }

    private static Schema copySchema(Schema original) {
        Schema copy = new Schema();
        int i = 0;
        while (i < original.getColumnCount()) {
            copy.addColumn(original.getColumnName(i), original.getColumnType(i));
            ++i;
        }
        return copy;
    }

    private static Schema appendKNNColumn(Schema targetSchema) throws AlgorithmExecutionException {
        if (targetSchema.getColumnIndex("knn") < 0) {
            targetSchema.addColumn("knn", Float.TYPE);
        } else {
            KNNCalculator.throwException("knn");
        }
        return targetSchema;
    }

    private static void throwException(String type) throws AlgorithmExecutionException {
        throw new AlgorithmExecutionException("Attribute: " + type + " already exists. Please rename the attribute before rerunning this algorithm.");
    }

    private static File writeDegreeDegreeCorrelations(Map degreeToKNNSum, Map degreeToDegreeCounts, File outputFile, int numberOfNodes) throws AlgorithmExecutionException {
        long sum = (numberOfNodes - 1) * numberOfNodes / 2;
        double expected = (double)sum / (double)numberOfNodes;
        try {
            FileWriter fw = new FileWriter(outputFile);
            TreeSet keySet = new TreeSet(degreeToKNNSum.keySet());
            fw.flush();
            for (Object o : keySet) {
                double knnValue = ((Float)degreeToKNNSum.get(o)).doubleValue();
                double degreeCount = ((Integer)degreeToDegreeCounts.get(o)).doubleValue();
                fw.write(o + "\t" + knnValue / degreeCount / expected + System.getProperty("line.separator"));
            }
            fw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            throw new AlgorithmExecutionException("Error writing the Degree-Degree Correlation file.", (Throwable)ioe);
        }
        return outputFile;
    }
}

