/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.java.undirectedknn.components;

import edu.iu.nwb.analysis.java.undirectedknn.components.KNNCalculator;
import java.util.Iterator;
import java.util.Map;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;

public class KNNCalculatorThread
extends Thread {
    private final Graph originalGraph;
    private Graph targetGraph;
    private int start;
    private int end;
    private KNNCalculator mainCalculator;
    private Map degreeToKNN;
    private Map degreeToCountDegree;

    public KNNCalculatorThread(Graph orgGraph, Graph trgtGraph, int start, int end, KNNCalculator kCalc, Map sumNeighbor, Map countDegreeMap) {
        this.originalGraph = orgGraph;
        this.targetGraph = trgtGraph;
        this.start = start;
        this.end = end;
        this.mainCalculator = kCalc;
        this.degreeToKNN = sumNeighbor;
        this.degreeToCountDegree = countDegreeMap;
    }

    @Override
    public void run() {
        super.run();
        Table sourceNodeTable = this.originalGraph.getNodeTable();
        Table targetNodeTable = this.targetGraph.getNodeTable();
        int tenPercent = (int)Math.ceil((this.end - this.start) / 10);
        if (tenPercent == 0) {
            tenPercent = 1;
        }
        int counter = 1;
        int i = this.start;
        while (i < this.end) {
            if (counter % tenPercent == 0) {
                KNNCalculator.updateProgress(this.mainCalculator, counter);
            }
            int j = 0;
            while (j < sourceNodeTable.getColumnCount()) {
                targetNodeTable.set(i, j, sourceNodeTable.get(i, j));
                ++j;
            }
            Node retrievedNode = this.originalGraph.getNode(i);
            float knn = this.calculateNeighborsAvgDegree(retrievedNode);
            targetNodeTable.setFloat(i, "knn", knn);
            this.updateMaps(retrievedNode.getDegree(), knn);
            ++i;
        }
    }

    private float calculateNeighborsAvgDegree(Node n) {
        float answer = 0.0f;
        if (n.getDegree() == 0) {
            return 0.0f;
        }
        Iterator i = n.neighbors();
        while (i.hasNext()) {
            Node neighbor = (Node)i.next();
            answer += (float)neighbor.getDegree();
        }
        return answer / (float)n.getDegree();
    }

    private void updateMaps(int degree, float neighborsDegreeCalculation) {
        Float knnValue = (Float)this.degreeToKNN.get(new Integer(degree));
        if (knnValue == null) {
            this.degreeToKNN.put(new Integer(degree), new Float(neighborsDegreeCalculation));
            this.degreeToCountDegree.put(new Integer(degree), new Integer(1));
        } else {
            knnValue = new Float(knnValue.floatValue() + neighborsDegreeCalculation);
            this.degreeToKNN.put(new Integer(degree), knnValue);
            int count = (Integer)this.degreeToCountDegree.get(new Integer(degree));
            this.degreeToCountDegree.put(new Integer(degree), new Integer(count + 1));
        }
    }
}

