/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.kcore;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.UserData;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class Annotate
implements Algorithm {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;
    private String attributeName = "nwb_coreness";

    public Annotate(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
    }

    public Data[] execute() {
        Graph inputGraph = (Graph)this.data[0].getData();
        Graph outputGraph = (Graph)inputGraph.copy();
        Graph calcGraph = (Graph)outputGraph.copy();
        int currentCore = 0;
        while (calcGraph.numVertices() > 0) {
            HashSet toCheck = calcGraph.getVertices();
            while (toCheck.size() > 0) {
                Iterator checking = toCheck.iterator();
                toCheck = new HashSet();
                HashSet<Vertex> toRemove = new HashSet<Vertex>();
                while (checking.hasNext()) {
                    Vertex vertex = (Vertex)checking.next();
                    if (vertex.degree() > currentCore) continue;
                    vertex.getEqualVertex((ArchetypeGraph)outputGraph).setUserDatum((Object)this.attributeName, (Object)new Integer(currentCore), UserData.SHARED);
                    toCheck.addAll(vertex.getNeighbors());
                    toRemove.add(vertex);
                }
                toCheck.removeAll(toRemove);
                GraphUtils.removeVertices((Graph)calcGraph, toRemove);
            }
            ++currentCore;
        }
        BasicData output = new BasicData((Object)outputGraph, Graph.class.getName());
        Dictionary metadata = output.getMetadata();
        metadata.put("Label", "K-Coreness annotated graph");
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Network");
        return new Data[]{output};
    }
}

