/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.kcore;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class Extract
implements Algorithm {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;

    public Extract(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
    }

    public Data[] execute() {
        LogService logger = (LogService)this.context.getService(LogService.class.getName());
        Graph inputGraph = (Graph)this.data[0].getData();
        logger.log(3, inputGraph.numVertices() + " input nodes");
        int core = (Integer)this.parameters.get("k");
        Graph outputGraph = (Graph)inputGraph.copy();
        int currentCore = 0;
        while (currentCore < core) {
            HashSet toCheck = outputGraph.getVertices();
            while (toCheck.size() > 0) {
                Iterator checking = toCheck.iterator();
                toCheck = new HashSet();
                HashSet<Vertex> toRemove = new HashSet<Vertex>();
                while (checking.hasNext()) {
                    Vertex vertex = (Vertex)checking.next();
                    if (vertex.degree() > currentCore) continue;
                    toCheck.addAll(vertex.getNeighbors());
                    toRemove.add(vertex);
                }
                toCheck.removeAll(toRemove);
                GraphUtils.removeVertices((Graph)outputGraph, toRemove);
            }
            ++currentCore;
        }
        BasicData output = new BasicData((Object)outputGraph, Graph.class.getName());
        Dictionary metadata = output.getMetadata();
        metadata.put("Label", "k-Core # " + core + ", with " + outputGraph.numVertices() + " of " + inputGraph.numVertices() + " nodes");
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Network");
        return new Data[]{output};
    }
}

