/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.multipartitejoining;

import cern.colt.function.ObjectFunction;
import cern.colt.function.ObjectObjectFunction;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.impl.SparseObjectMatrix2D;
import cern.colt.matrix.impl.SparseObjectMatrix3D;
import edu.iu.nwb.analysis.multipartitejoining.FieldFetcher;
import edu.iu.nwb.analysis.multipartitejoining.NumberMapper;
import edu.iu.nwb.analysis.multipartitejoining.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.TableTuple;

public class JoiningAlgorithm
implements Algorithm {
    private static final String WEIGHT_COLUMN = "weight";
    private static final String SEPARATOR = "\\.";
    private Data[] data;
    private Dictionary parameters;
    private CIShellContext context;
    private LogService log;
    private Map transferred;
    private static Map typeMap = new HashMap();

    static {
        typeMap.put("count", Integer.TYPE);
    }

    public JoiningAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
        this.transferred = new HashMap();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Node first;
        this.log = (LogService)this.context.getService(LogService.class.getName());
        Graph inputGraph = (Graph)this.data[0].getData();
        String key = (String)this.parameters.get("key");
        String type = (String)this.parameters.get("type");
        String join = (String)this.parameters.get("join");
        File metadataFile = new File((String)this.parameters.get("metadata"));
        Properties metadata = new Properties();
        try {
            metadata.load(new FileInputStream(metadataFile));
        }
        catch (FileNotFoundException e) {
            throw new AlgorithmExecutionException("The file " + metadataFile.getAbsolutePath() + " was not found.", (Throwable)e);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException("There was a problem loading the file " + metadataFile.getAbsolutePath(), (Throwable)e);
        }
        Schema inputNodeSchema = inputGraph.getNodeTable().getSchema();
        Schema outputNodeSchema = this.enhanceNodeSchema(inputNodeSchema, metadata);
        Schema outputEdgeSchema = this.createEdgeSchema(inputNodeSchema, metadata);
        Graph outputGraph = new Graph(outputNodeSchema.instantiate(), outputEdgeSchema.instantiate(), false);
        Table nodes = inputGraph.getNodeTable();
        Iterator joinTemp = nodes.tuples(ExpressionParser.predicate((String)("[" + key + "] = \"" + join + "\"")));
        int totalJoinNodes = 0;
        while (joinTemp.hasNext()) {
            ++totalJoinNodes;
            joinTemp.next();
        }
        int nodeCount = inputGraph.getNodeCount();
        SparseObjectMatrix3D edgeMatrix = new SparseObjectMatrix3D(totalJoinNodes, nodeCount, nodeCount);
        SparseObjectMatrix2D nodeMatrix = new SparseObjectMatrix2D(nodeCount, totalJoinNodes);
        Iterator typeIterator = nodes.tuples(ExpressionParser.predicate((String)("[" + key + "] = \"" + type + "\"")));
        Iterator joinIterator = nodes.tuples(ExpressionParser.predicate((String)("[" + key + "] = \"" + join + "\"")));
        Vector<Node> typeNodes = new Vector<Node>();
        while (typeIterator.hasNext()) {
            typeNodes.add(inputGraph.getNode(((TableTuple)typeIterator.next()).getRow()));
        }
        int currentJoinNodeLocation = 0;
        while (joinIterator.hasNext()) {
            Node joinNode = inputGraph.getNode(((TableTuple)joinIterator.next()).getRow());
            ++currentJoinNodeLocation;
            Iterator neighbors = joinNode.neighbors();
            Stack<Node> typeNeighbors = new Stack<Node>();
            while (neighbors.hasNext()) {
                Node neighbor = (Node)neighbors.next();
                if (!typeNodes.contains(neighbor)) continue;
                typeNeighbors.push(neighbor);
            }
            while (!typeNeighbors.isEmpty()) {
                first = (Node)typeNeighbors.pop();
                for (Node second : typeNeighbors) {
                    int row = Math.min(first.getRow(), second.getRow());
                    int column = Math.max(first.getRow(), second.getRow());
                    edgeMatrix.setQuick(currentJoinNodeLocation, row, column, (Object)joinNode);
                    nodeMatrix.setQuick(first.getRow(), currentJoinNodeLocation, (Object)joinNode);
                    nodeMatrix.setQuick(second.getRow(), currentJoinNodeLocation, (Object)joinNode);
                }
            }
        }
        int row = 0;
        while (row < edgeMatrix.rows()) {
            int column = 0;
            while (column < edgeMatrix.columns()) {
                ObjectMatrix1D joins = edgeMatrix.viewRow(row).viewColumn(column);
                if (joins.cardinality() > 0) {
                    first = this.moveTo(inputGraph.getNode(row), outputGraph);
                    Node second = this.moveTo(inputGraph.getNode(column), outputGraph);
                    this.foldEdge(first, second, joins, metadata);
                }
                ++column;
            }
            ++row;
        }
        row = 0;
        while (row < nodeMatrix.rows()) {
            ObjectMatrix1D joins = nodeMatrix.viewRow(row);
            Node rowNode = inputGraph.getNode(row);
            if (typeNodes.contains(rowNode)) {
                Node node = this.moveTo(rowNode, outputGraph);
                if (joins.cardinality() > 0) {
                    this.foldNode(node, joins, metadata);
                }
            }
            ++row;
        }
        BasicData outputData = new BasicData((Object)outputGraph, Graph.class.getName());
        Dictionary attributes = outputData.getMetadata();
        attributes.put("Modified", new Boolean(true));
        attributes.put("Parent", this.data[0]);
        attributes.put("Type", "Network");
        attributes.put("Label", "Graph of a join of " + type + " nodes across " + join + " nodes.");
        return new Data[]{outputData};
    }

    private void foldNode(Node node, ObjectMatrix1D joins, Properties metadata) {
        Enumeration<?> keys = metadata.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] keyArray = metadata.getProperty(key).split(SEPARATOR);
            String sourceField = keyArray[0];
            String operation = keyArray[1];
            if (key.startsWith("edge.")) continue;
            this.foldField(operation, sourceField, key, joins, (Tuple)node);
        }
    }

    private Schema createEdgeSchema(Schema joinSchema, Properties metadata) {
        Schema output = new Schema();
        output.addColumn("source", Integer.TYPE);
        output.addColumn("target", Integer.TYPE);
        boolean weightSpecifiedFlag = false;
        Enumeration<?> keys = metadata.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("edge.")) continue;
            String realKey = key.split(SEPARATOR)[1];
            if (realKey.equals(WEIGHT_COLUMN)) {
                weightSpecifiedFlag = true;
                continue;
            }
            if (realKey.equals("source") || realKey.equals("target")) {
                this.log.log(2, "The metadata key " + realKey + " is not allowed for edges and will be ignored.");
                continue;
            }
            String fromKey = metadata.getProperty(key).split(SEPARATOR)[0];
            output.addColumn(realKey, joinSchema.getColumnType(fromKey));
        }
        if (!weightSpecifiedFlag) {
            output.addColumn(WEIGHT_COLUMN, Integer.TYPE, (Object)new Integer(1));
        }
        return output;
    }

    private void foldEdge(Node first, Node second, ObjectMatrix1D joins, Properties metadata) {
        boolean weightSpecifiedFlag = false;
        Edge edge = first.getGraph().getEdge(first, second);
        if (edge == null) {
            edge = first.getGraph().addEdge(first, second);
        }
        Enumeration<?> keys = metadata.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] keyArray = metadata.getProperty(key).split(SEPARATOR);
            String sourceField = keyArray[0];
            String operation = keyArray[1];
            if (!key.startsWith("edge.")) continue;
            String realKey = key.split(SEPARATOR)[1];
            if (realKey.equals(WEIGHT_COLUMN)) {
                weightSpecifiedFlag = true;
            }
            this.foldField(operation, sourceField, realKey, joins, (Tuple)edge);
        }
        if (!weightSpecifiedFlag) {
            edge.setInt(WEIGHT_COLUMN, Util.number(joins));
        }
    }

    private void foldField(String operation, String sourceField, String key, ObjectMatrix1D joins, Tuple tuple) {
        int cardinality = joins.cardinality();
        if ("sum".equals(operation)) {
            if (tuple.canSetDouble(key)) {
                tuple.setDouble(key, Util.doubleSum(joins, sourceField));
            } else if (tuple.canSetFloat(key)) {
                tuple.setFloat(key, Util.floatSum(joins, sourceField));
            } else if (tuple.canSetLong(key)) {
                tuple.setLong(key, Util.longSum(joins, sourceField));
            } else if (tuple.canSetInt(key)) {
                tuple.setFloat(key, (float)Util.integerSum(joins, sourceField));
            }
        } else if ("average".equals(operation)) {
            if (tuple.canSetDouble(key)) {
                tuple.setDouble(key, Util.doubleSum(joins, sourceField) / (double)cardinality);
            } else if (tuple.canSetFloat(key)) {
                tuple.setFloat(key, Util.floatSum(joins, sourceField) / (float)cardinality);
            } else if (tuple.canSetLong(key)) {
                tuple.setLong(key, Util.longSum(joins, sourceField) / (long)cardinality);
            } else if (tuple.canSetInt(key)) {
                tuple.setFloat(key, (float)(Util.integerSum(joins, sourceField) / cardinality));
            }
        } else if ("min".equals(operation)) {
            if (tuple.canSetDouble(key)) {
                tuple.setDouble(key, Util.doubleMin(joins, sourceField));
            } else if (tuple.canSetFloat(key)) {
                tuple.setFloat(key, Util.floatMin(joins, sourceField));
            } else if (tuple.canSetLong(key)) {
                tuple.setLong(key, Util.longMin(joins, sourceField));
            } else if (tuple.canSetInt(key)) {
                tuple.setFloat(key, (float)Util.integerMin(joins, sourceField));
            }
        } else if ("max".equals(operation)) {
            if (tuple.canSetDouble(key)) {
                tuple.setDouble(key, Util.doubleMax(joins, sourceField));
            } else if (tuple.canSetFloat(key)) {
                tuple.setFloat(key, Util.floatMax(joins, sourceField));
            } else if (tuple.canSetLong(key)) {
                tuple.setLong(key, Util.longMax(joins, sourceField));
            } else if (tuple.canSetInt(key)) {
                tuple.setFloat(key, (float)Util.integerMax(joins, sourceField));
            }
        } else if ("mode".equals(operation)) {
            final Map map = (Map)joins.aggregate((ObjectObjectFunction)new NumberMapper(), (ObjectFunction)new FieldFetcher(sourceField));
            Object[] possibles = map.keySet().toArray();
            Arrays.sort(possibles, new Comparator(){

                public int compare(Object one, Object two) {
                    Integer first = (Integer)map.get(one);
                    Integer second = (Integer)map.get(two);
                    return first.compareTo(second);
                }
            });
            tuple.set(key, possibles[possibles.length - 1]);
        } else if ("count".equals(operation)) {
            tuple.setInt(key, Util.number(joins));
        }
    }

    private Schema enhanceNodeSchema(Schema schema, Properties metadata) {
        Schema output = new Schema();
        Enumeration<?> keys = metadata.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.startsWith("edge.")) continue;
            if (schema.getColumnIndex(key) != -1) {
                this.log.log(1, "The metadata key " + key + " is already in use for this graph. It will be overwriten with the new value.");
            }
            String[] split = metadata.getProperty(key).split(SEPARATOR);
            String fromKey = split[0];
            String operation = split[1];
            Class type = (Class)typeMap.get(operation);
            if (type == null) {
                type = schema.getColumnType(fromKey);
            }
            output.addColumn(key, type);
        }
        int ii = 0;
        while (ii < schema.getColumnCount()) {
            String columnName = schema.getColumnName(ii);
            if (output.getColumnIndex(columnName) == -1) {
                output.addColumn(columnName, schema.getColumnType(columnName), schema.getDefault(columnName));
            }
            ++ii;
        }
        return output;
    }

    private Node moveTo(Node oldNode, Graph newGraph) {
        if (this.transferred.keySet().contains(oldNode)) {
            return (Node)this.transferred.get(oldNode);
        }
        Node newNode = newGraph.addNode();
        Schema newSchema = newGraph.getNodeTable().getSchema();
        int columnIndex = 0;
        while (columnIndex < oldNode.getColumnCount()) {
            String columnName = oldNode.getColumnName(columnIndex);
            if (newSchema.getColumnIndex(columnName) != -1) {
                newNode.set(columnName, oldNode.get(columnIndex));
            }
            ++columnIndex;
        }
        this.transferred.put(oldNode, newNode);
        return newNode;
    }
}

