/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.nodebetweennesscentrality;

import edu.iu.cns.graphstream.common.AnnotatedGraph;
import edu.iu.cns.graphstream.common.Utilities;
import java.util.Dictionary;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.graphstream.algorithm.BetweennessCentrality;
import org.graphstream.graph.Graph;

public class NodeBetweennessCentralityAlgorithm
implements Algorithm {
    private Data inputData;
    private AnnotatedGraph graph;
    private String weightAttributeName;
    private boolean isWeighted;
    private String centralityAttributeName;

    public NodeBetweennessCentralityAlgorithm(Data inputData, AnnotatedGraph graph, String weightAttributeName, boolean isWeighted, String centralityAttributeName) {
        this.inputData = inputData;
        this.graph = graph;
        this.weightAttributeName = weightAttributeName;
        this.isWeighted = isWeighted;
        this.centralityAttributeName = centralityAttributeName;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        BetweennessCentrality betweennessCentralityCalculator = this.createBetweennessCentralityCalculator();
        AnnotatedGraph outputGraph = this.createOutputGraph();
        betweennessCentralityCalculator.betweennessCentrality((Graph)outputGraph);
        return this.wrapAsData(outputGraph);
    }

    private AnnotatedGraph createOutputGraph() {
        AnnotatedGraph outputGraph = new AnnotatedGraph(this.graph);
        Utilities.addNodeAttribute((AnnotatedGraph)outputGraph, (String)this.centralityAttributeName, (String)"float");
        return outputGraph;
    }

    private BetweennessCentrality createBetweennessCentralityCalculator() {
        if (this.isWeighted) {
            return new BetweennessCentrality(this.centralityAttributeName, this.weightAttributeName);
        }
        return new BetweennessCentrality(this.centralityAttributeName);
    }

    private Data[] wrapAsData(AnnotatedGraph outputGraph) {
        BasicData outputData = new BasicData((Object)outputGraph, outputGraph.getClass().getName());
        Dictionary metadata = outputData.getMetadata();
        metadata.put("Parent", this.inputData);
        String label = String.format("With '%s' as the Betweenness Centrality", this.centralityAttributeName);
        metadata.put("Label", label);
        metadata.put("Type", "Network");
        return new Data[]{outputData};
    }
}

