/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.nodebetweennesscentrality;

import edu.iu.cns.graphstream.common.AnnotatedGraph;
import edu.iu.nwb.analysis.nodebetweennesscentrality.NodeBetweennessCentralityAlgorithm;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.List;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmCreationFailedException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.cishell.utilities.MutateParameterUtilities;
import org.cishell.utilities.StringUtilities;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class NodeBetweennessCentralityAlgorithmFactory
implements AlgorithmFactory,
ParameterMutator {
    public static final String BOTH_EDGE_TYPES_FOUND_EXCEPTION_MESSAGE = "Both directed and undirected edges were found in this network. Only directed OR undirected edges are allowed.";
    public static final String BOTH_EDGE_TYPES_NOT_FOUND_EXCEPTION_MESSAGE = "Neither directed nor undirected edges were found in this network. It must contain either directed or undirected edges.";
    public static final String WEIGHT_KEY = "weight";
    public static final String CENTRALITY_ATTRIBUTE_NAME_KEY = "centralityAttributeName";
    public static final String NO_EDGE_WEIGHT_VALUE = "unweighted";

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext ciShellContext) {
        Data inputData = data[0];
        AnnotatedGraph graph = (AnnotatedGraph)inputData.getData();
        String weightAttributeName = (String)parameters.get(WEIGHT_KEY);
        boolean isWeighted = NO_EDGE_WEIGHT_VALUE.equals(weightAttributeName);
        String centralityAttributeName = (String)parameters.get(CENTRALITY_ATTRIBUTE_NAME_KEY);
        return new NodeBetweennessCentralityAlgorithm(inputData, graph, weightAttributeName, isWeighted, centralityAttributeName);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition oldParameters) {
        final AnnotatedGraph graph = (AnnotatedGraph)data[0].getData();
        LinkedHashMap<String, String> edgeSchema = NodeBetweennessCentralityAlgorithmFactory.getEdgeSchema(graph);
        BasicObjectClassDefinition newParameters = MutateParameterUtilities.createNewParameters((ObjectClassDefinition)oldParameters);
        AttributeDefinition[] oldAttributes = oldParameters.getAttributeDefinitions(-1);
        List<String> numberKeysTypes = Arrays.asList("int", "float");
        List<String> numberKeysToSkip = Arrays.asList("source", "target");
        List<String> numberKeysToAdd = Arrays.asList(NO_EDGE_WEIGHT_VALUE);
        AttributeDefinition[] attributeDefinitionArray = oldAttributes;
        int n = oldAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition oldAttribute = attributeDefinitionArray[n2];
            String id = oldAttribute.getID();
            String name = oldAttribute.getName();
            String description = oldAttribute.getDescription();
            int type = oldAttribute.getType();
            String[] defaultValue = oldAttribute.getDefaultValue();
            Object newAttribute = oldAttribute;
            if (WEIGHT_KEY.equals(id)) {
                newAttribute = MutateParameterUtilities.formAttributeDefinitionFromMap((AttributeDefinition)oldAttribute, edgeSchema, numberKeysTypes, numberKeysToSkip, numberKeysToAdd);
            } else if (CENTRALITY_ATTRIBUTE_NAME_KEY.equals(id)) {
                newAttribute = new BasicAttributeDefinition(id, name, description, type, defaultValue[0]){

                    public String validate(String value) {
                        String preValidation = super.validate(value);
                        if (!StringUtilities.isNull_Empty_OrWhitespace((String)preValidation)) {
                            return preValidation;
                        }
                        if (graph.getNodeSchema().containsKey(value)) {
                            String errorMessage = String.format("The input graph already contains the node property '%s'.", value);
                            return errorMessage;
                        }
                        return null;
                    }
                };
            }
            newParameters.addAttributeDefinition(1, newAttribute);
            ++n2;
        }
        return newParameters;
    }

    private static LinkedHashMap<String, String> getEdgeSchema(AnnotatedGraph graph) {
        LinkedHashMap directedEdgeSchema = graph.getDirectedEdgeSchema();
        LinkedHashMap undirectedEdgeSchema = graph.getUndirectedEdgeSchema();
        if (directedEdgeSchema != null) {
            if (undirectedEdgeSchema != null) {
                throw new AlgorithmCreationFailedException(BOTH_EDGE_TYPES_FOUND_EXCEPTION_MESSAGE);
            }
            return directedEdgeSchema;
        }
        if (undirectedEdgeSchema == null) {
            throw new AlgorithmCreationFailedException(BOTH_EDGE_TYPES_NOT_FOUND_EXCEPTION_MESSAGE);
        }
        return undirectedEdgeSchema;
    }
}

