/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.pagerank.weighted;

import edu.iu.nwb.analysis.pagerank.weighted.WeightAccessor;
import java.util.Map;

public class ColumnWeightAccessor
implements WeightAccessor {
    private String weightAttribute;

    public ColumnWeightAccessor(String weightAttribute) {
        this.weightAttribute = weightAttribute;
    }

    @Override
    public float getWeight(Map<String, Object> attributes) throws WeightAccessor.InvalidWeightException {
        Float weight = (Float)attributes.get(this.weightAttribute);
        assert (weight != null);
        if (weight.floatValue() <= 0.0f) {
            throw new WeightAccessor.InvalidWeightException("This algorithm can only be run on positively weighted networks.");
        }
        if (Float.isNaN(weight.floatValue())) {
            throw new WeightAccessor.InvalidWeightException("Weight must not be NaN.");
        }
        if (Float.isInfinite(weight.floatValue())) {
            throw new WeightAccessor.InvalidWeightException("Weight must not be infinite.");
        }
        return weight.floatValue();
    }
}

