/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.pagerank.weighted;

import edu.iu.nwb.analysis.pagerank.weighted.Edge;
import edu.iu.nwb.analysis.pagerank.weighted.EdgeHandler;
import edu.iu.nwb.analysis.pagerank.weighted.Graph;
import edu.iu.nwb.analysis.pagerank.weighted.WeightAccessor;
import edu.iu.nwb.analysis.pagerank.weighted.WeightedPagerank;
import edu.iu.nwb.util.nwbfile.NWBFileParserAdapter;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cishell.framework.algorithm.AlgorithmExecutionException;

public class InMemoryGraph
extends Graph {
    private List<Edge> edges;

    public InMemoryGraph(File nwbFile, WeightAccessor weightAccessor, int numberOfNodes, int numberOfDirectedEdges) throws AlgorithmExecutionException {
        this.numberOfNodes = numberOfNodes;
        this.edges = InMemoryGraph.accumulateEdges(nwbFile, weightAccessor, numberOfDirectedEdges);
    }

    private static List<Edge> accumulateEdges(File nwbFile, final WeightAccessor weightAccessor, int numberOfDirectedEdges) throws AlgorithmExecutionException {
        final ArrayList<Edge> edges = new ArrayList<Edge>(numberOfDirectedEdges + 1);
        WeightedPagerank.parseNWBFile(nwbFile, (NWBFileParserHandler)new NWBFileParserAdapter(){

            public void addDirectedEdge(int source, int target, Map<String, Object> attributes) {
                try {
                    edges.add(new Edge(source, target, weightAccessor.getWeight(attributes)));
                }
                catch (WeightAccessor.InvalidWeightException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return edges;
    }

    @Override
    public void performEdgePass(EdgeHandler handler) {
        for (Edge edge : this.edges) {
            handler.handleEdge(edge);
        }
    }
}

