/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.pagerank.weighted;

import cern.colt.matrix.DoubleMatrix1D;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.osgi.service.log.LogService;

public class NWBIntegrator
implements NWBFileParserHandler {
    private Map<Integer, Integer> nodeLookup;
    private DoubleMatrix1D pagerank;
    private NWBFileWriter outputWriter;
    private File outputFile;
    private LogService log;

    public NWBIntegrator(Map<Integer, Integer> nodeLookup, DoubleMatrix1D pagerank, LogService log) throws AlgorithmExecutionException {
        try {
            this.outputFile = File.createTempFile("nwb-", ".nwb");
            this.outputWriter = new NWBFileWriter(this.outputFile);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException("Unable to write output file: " + e.toString(), (Throwable)e);
        }
        this.nodeLookup = nodeLookup;
        this.pagerank = pagerank;
        this.log = log;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void addComment(String comment) {
        this.outputWriter.addComment(comment);
    }

    public void addDirectedEdge(int sourceNode, int targetNode, Map<String, Object> attributes) {
        this.outputWriter.addDirectedEdge(sourceNode, targetNode, attributes);
    }

    public void addNode(int id, String label, Map<String, Object> attributes) {
        Integer fakeId = this.nodeLookup.get(id);
        float pagerankValue = fakeId == null ? Double.valueOf(this.pagerank.getQuick(this.pagerank.size() - 1)).floatValue() : Double.valueOf(this.pagerank.getQuick(fakeId.intValue())).floatValue();
        attributes.put("nwbWeightedPagerank", Float.valueOf(pagerankValue));
        this.outputWriter.addNode(id, label, attributes);
    }

    public void addUndirectedEdge(int node1, int node2, Map<String, Object> attributes) {
        throw new UnsupportedOperationException("Undirected Edges are not supported by Page Rank.");
    }

    public void finishedParsing() {
        this.outputWriter.finishedParsing();
    }

    public boolean haltParsingNow() {
        return false;
    }

    public void setDirectedEdgeCount(int numberOfEdges) {
        this.log.log(4, "setDirectedEdgeCount is not supported by Weighted PageRank.");
    }

    public void setDirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.outputWriter.setDirectedEdgeSchema(schema);
    }

    public void setNodeCount(int numberOfNodes) {
        this.outputWriter.setNodeCount(this.pagerank.size());
    }

    public void setNodeSchema(LinkedHashMap<String, String> schema) {
        schema.put("nwbWeightedPagerank", "float");
        this.outputWriter.setNodeSchema(schema);
    }

    public void setUndirectedEdgeCount(int numberOfEdges) {
        throw new UnsupportedOperationException("Undirected Edges are not supported by Page Rank.");
    }

    public void setUndirectedEdgeSchema(LinkedHashMap<String, String> schema) {
        this.outputWriter.setUndirectedEdgeSchema(schema);
    }
}

