/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.pagerank.weighted;

import edu.iu.nwb.analysis.pagerank.weighted.Edge;
import edu.iu.nwb.analysis.pagerank.weighted.EdgeHandler;
import edu.iu.nwb.analysis.pagerank.weighted.Graph;
import edu.iu.nwb.analysis.pagerank.weighted.WeightAccessor;
import edu.iu.nwb.analysis.pagerank.weighted.WeightedPagerank;
import edu.iu.nwb.util.nwbfile.NWBFileParserAdapter;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import java.io.File;
import java.util.Map;
import org.cishell.framework.algorithm.AlgorithmExecutionException;

public class OnDiskGraph
extends Graph {
    private File nwbFile;
    private WeightAccessor weightAccessor;

    public OnDiskGraph(File nwbFile, WeightAccessor weightAccessor, int numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        this.nwbFile = nwbFile;
        this.weightAccessor = weightAccessor;
    }

    @Override
    public void performEdgePass(final EdgeHandler handler) throws AlgorithmExecutionException {
        WeightedPagerank.parseNWBFile(this.nwbFile, (NWBFileParserHandler)new NWBFileParserAdapter(){

            public void addDirectedEdge(int source, int target, Map<String, Object> attributes) {
                try {
                    handler.handleEdge(new Edge(source, target, OnDiskGraph.this.weightAccessor.getWeight(attributes)));
                }
                catch (WeightAccessor.InvalidWeightException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

