/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.pagerank.weighted;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.math.Functions;
import edu.iu.nwb.analysis.pagerank.weighted.ColumnWeightAccessor;
import edu.iu.nwb.analysis.pagerank.weighted.ConstantWeightAccessor;
import edu.iu.nwb.analysis.pagerank.weighted.Edge;
import edu.iu.nwb.analysis.pagerank.weighted.EdgeHandler;
import edu.iu.nwb.analysis.pagerank.weighted.Graph;
import edu.iu.nwb.analysis.pagerank.weighted.InMemoryGraph;
import edu.iu.nwb.analysis.pagerank.weighted.NWBIntegrator;
import edu.iu.nwb.analysis.pagerank.weighted.OnDiskGraph;
import edu.iu.nwb.analysis.pagerank.weighted.WeightAccessor;
import edu.iu.nwb.util.nwbfile.GetMetadataAndCounts;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.Data;
import org.cishell.utilities.DataFactory;
import org.osgi.service.log.LogService;

public class WeightedPagerank
implements Algorithm {
    private Data[] data;
    private Dictionary<String, Object> parameters;
    private LogService log;

    public WeightedPagerank(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.log = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File nwbFile = (File)this.data[0].getData();
        String weightAttribute = (String)this.parameters.get("weightAttribute");
        WeightAccessor weightAccessor = WeightedPagerank.makeWeightAccessor(weightAttribute);
        double dampingFactor = (Double)this.parameters.get("d");
        Data nwbOutput = this.annotateWithPagerank(nwbFile, weightAccessor, dampingFactor);
        return new Data[]{nwbOutput};
    }

    private Data annotateWithPagerank(File nwbFile, WeightAccessor weightAccessor, double dampingFactor) throws AlgorithmExecutionException {
        Graph graph = WeightedPagerank.prepareEdges(nwbFile, weightAccessor);
        int numberOfNodes = graph.getNumberOfNodes();
        Map<Integer, Integer> nodeLookup = this.createSequentialLookup(graph);
        DoubleMatrix1D pagerank = this.calculatePagerank(graph, nodeLookup, numberOfNodes, dampingFactor);
        Data nwbOutput = this.annotateFile(nwbFile, nodeLookup, pagerank);
        return nwbOutput;
    }

    private Data annotateFile(File nwbFile, Map<Integer, Integer> nodeLookup, DoubleMatrix1D pagerank) throws AlgorithmExecutionException {
        NWBIntegrator integrator = WeightedPagerank.annotateInputFile(nwbFile, nodeLookup, pagerank, this.log);
        Data nwbOutput = this.prepareData(integrator.getOutputFile());
        return nwbOutput;
    }

    private static NWBIntegrator annotateInputFile(File nwbFile, Map<Integer, Integer> nodeLookup, DoubleMatrix1D pagerank, LogService log) throws AlgorithmExecutionException {
        NWBIntegrator integrator = new NWBIntegrator(nodeLookup, pagerank, log);
        WeightedPagerank.parseNWBFile(nwbFile, integrator);
        return integrator;
    }

    private static WeightAccessor makeWeightAccessor(String weightColumnName) {
        if ("Treat all edges as weight one.".equals(weightColumnName)) {
            return new ConstantWeightAccessor(1.0f);
        }
        return new ColumnWeightAccessor(weightColumnName);
    }

    private Data prepareData(File file) {
        return DataFactory.forObject((Object)file, (String)"file:text/nwb", (String)"Network", (Data)this.data[0], (String)"with Pagerank");
    }

    private DoubleMatrix1D calculatePagerank(Graph graph, final Map<Integer, Integer> nodeLookup, final int numberOfNodes, final double dampingFactor) throws AlgorithmExecutionException {
        final DoubleMatrix1D normStrengths = this.calculateNormStrengths(graph, nodeLookup, numberOfNodes, dampingFactor);
        int[] stopnodes = this.determineStopnodeIndices(normStrengths);
        DoubleMatrix1D currentValues = DoubleFactory1D.dense.make(numberOfNodes, 1.0 / (double)numberOfNodes);
        boolean finished = false;
        while (!finished) {
            final DoubleMatrix1D previousValues = currentValues;
            DoubleMatrix1D stopnodeValues = previousValues.viewSelection(stopnodes);
            double stopnodeContributions = stopnodeValues.aggregate(Functions.plus, new DoubleFunction(){

                public double apply(double arg) {
                    return arg * dampingFactor / (double)numberOfNodes;
                }
            });
            final DoubleMatrix1D currentValues2 = currentValues = DoubleFactory1D.dense.make(numberOfNodes, stopnodeContributions + (1.0 - dampingFactor) / (double)numberOfNodes);
            graph.performEdgePass(new EdgeHandler(){

                @Override
                public void handleEdge(Edge edge) {
                    int source = (Integer)nodeLookup.get(edge.getSource());
                    int target = (Integer)nodeLookup.get(edge.getTarget());
                    currentValues2.setQuick(target, currentValues2.getQuick(target) + normStrengths.get(source) * previousValues.get(source) * edge.getWeight());
                }
            });
            finished = this.isWithinTolerance(currentValues, previousValues);
            if (!(Math.abs(currentValues.zSum() - 1.0) > 1.0E-5)) continue;
            throw new IllegalArgumentException("Alert: The total pagerank is not 1. This should not be possible. The total pagerank is " + currentValues.zSum());
        }
        return currentValues;
    }

    private boolean isWithinTolerance(DoubleMatrix1D currentValues, DoubleMatrix1D previousValues) {
        boolean finished = previousValues.assign(currentValues, new DoubleDoubleFunction(){

            public double apply(double previousValue, double currentValue) {
                return Math.abs(currentValue - previousValue) / previousValue;
            }
        }).viewSelection(Functions.isLess((double)1.0E-5)).size() == previousValues.size();
        return finished;
    }

    private int[] determineStopnodeIndices(DoubleMatrix1D normStrengths) {
        ArrayList<Integer> stopnodeIndices = new ArrayList<Integer>();
        int index = 0;
        while (index < normStrengths.size()) {
            if (Double.isInfinite(normStrengths.getQuick(index))) {
                stopnodeIndices.add(index);
            }
            ++index;
        }
        int numberOfStopnodes = stopnodeIndices.size();
        int[] stopnodes = new int[numberOfStopnodes];
        int index2 = 0;
        while (index2 < numberOfStopnodes) {
            stopnodes[index2] = (Integer)stopnodeIndices.get(index2);
            ++index2;
        }
        return stopnodes;
    }

    private DoubleMatrix1D calculateNormStrengths(Graph graph, final Map<Integer, Integer> nodeLookup, int numberOfNodes, final double dampingFactor) throws AlgorithmExecutionException {
        final DoubleMatrix1D nodeStrengths = DoubleFactory1D.dense.make(numberOfNodes);
        graph.performEdgePass(new EdgeHandler(){

            @Override
            public void handleEdge(Edge edge) {
                int source = (Integer)nodeLookup.get(edge.getSource());
                double currentStrength = nodeStrengths.getQuick(source);
                nodeStrengths.setQuick(source, currentStrength + edge.getWeight());
            }
        });
        DoubleMatrix1D normStrengths = nodeStrengths.assign(new DoubleFunction(){

            public double apply(double arg) {
                return dampingFactor / arg;
            }
        });
        return normStrengths;
    }

    private Map<Integer, Integer> createSequentialLookup(Graph graph) throws AlgorithmExecutionException {
        final HashMap<Integer, Integer> nodeLookup = new HashMap<Integer, Integer>();
        graph.performEdgePass(new EdgeHandler(){
            private int nodeIndex = 0;

            @Override
            public void handleEdge(Edge edge) {
                this.indexNode(edge.getSource());
                this.indexNode(edge.getTarget());
            }

            private void indexNode(int nodeId) {
                if (!nodeLookup.containsKey(nodeId)) {
                    nodeLookup.put(nodeId, this.nodeIndex);
                    ++this.nodeIndex;
                }
            }
        });
        return nodeLookup;
    }

    private static Graph prepareEdges(File nwbFile, WeightAccessor weightAccessor) throws AlgorithmExecutionException {
        GetMetadataAndCounts networkInfo = new GetMetadataAndCounts();
        WeightedPagerank.parseNWBFile(nwbFile, (NWBFileParserHandler)networkInfo);
        int numberOfNodes = networkInfo.getNodeCount();
        int numberOfDirectedEdges = networkInfo.getDirectedEdgeCount();
        Runtime runtime = Runtime.getRuntime();
        long availableMemory = runtime.freeMemory() + (runtime.maxMemory() - runtime.totalMemory());
        long possibleEdges = availableMemory / 160L;
        Graph edges = (long)numberOfDirectedEdges > possibleEdges ? new OnDiskGraph(nwbFile, weightAccessor, numberOfNodes) : new InMemoryGraph(nwbFile, weightAccessor, numberOfNodes, numberOfDirectedEdges);
        return edges;
    }

    static void parseNWBFile(File nwbFile, NWBFileParserHandler handler) throws AlgorithmExecutionException {
        try {
            new NWBFileParser(nwbFile).parse(handler);
        }
        catch (ParsingException e) {
            throw new AlgorithmExecutionException("Problem parsing input file: " + e.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException("Problem reading input file: " + e.toString(), (Throwable)e);
        }
    }
}

