/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.pagerank.weighted;

import edu.iu.nwb.analysis.pagerank.weighted.WeightedPagerank;
import edu.iu.nwb.util.nwbfile.GetMetadataAndCounts;
import edu.iu.nwb.util.nwbfile.GetNWBFileMetadata;
import edu.iu.nwb.util.nwbfile.NWBFileParser;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileProperty;
import edu.iu.nwb.util.nwbfile.ParsingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.algorithm.DataValidator;
import org.cishell.framework.algorithm.ParameterMutator;
import org.cishell.framework.data.Data;
import org.cishell.reference.service.metatype.BasicAttributeDefinition;
import org.cishell.reference.service.metatype.BasicObjectClassDefinition;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class WeightedPagerankFactory
implements AlgorithmFactory,
DataValidator,
ParameterMutator {
    protected static final String TREAT_WEIGHT_AS_ONE = "Treat all edges as weight one.";
    protected static final String DAMPENING_FACTOR_ID = "d";
    protected static final String WEIGHT_ID = "weightAttribute";

    public Algorithm createAlgorithm(Data[] data, Dictionary<String, Object> parameters, CIShellContext context) {
        return new WeightedPagerank(data, parameters, context);
    }

    public String validate(Data[] data) {
        File nwbFile = (File)data[0].getData();
        GetMetadataAndCounts networkInfo = new GetMetadataAndCounts();
        try {
            NWBFileParser parser = new NWBFileParser(nwbFile);
            parser.parse((NWBFileParserHandler)networkInfo);
        }
        catch (IOException iOException) {
            return "Unable to read NWB file.";
        }
        catch (ParsingException parsingException) {
            return "Invalid NWB file format.";
        }
        int numberOfDirectedEdges = networkInfo.getDirectedEdgeCount();
        if (networkInfo.getUndirectedEdgeCount() > 0) {
            if (numberOfDirectedEdges > 0) {
                return "This network has both directed and undirected edges. The algorithm only works on entirely directed networks.";
            }
            return "This network is undirected. The algorithm only works on directed networks.";
        }
        if (numberOfDirectedEdges == 0) {
            return "This network has no edges. The algorithm requires edges to work.";
        }
        return "";
    }

    private static String[] findLikelyWeightColumns(Map<String, String> schema) {
        ArrayList<String> goodKeys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : schema.entrySet()) {
            if (!NWBFileProperty.NUMERIC_ATTRIBUTE_TYPES.contains(entry.getValue()) || NWBFileProperty.NECESSARY_EDGE_ATTRIBUTES.containsKey(entry.getKey())) continue;
            goodKeys.add(entry.getKey());
        }
        goodKeys.add(TREAT_WEIGHT_AS_ONE);
        Collections.reverse(goodKeys);
        return goodKeys.toArray(new String[goodKeys.size()]);
    }

    public ObjectClassDefinition mutateParameters(Data[] data, ObjectClassDefinition parameters) {
        BasicObjectClassDefinition definition;
        File nwbFile = (File)data[0].getData();
        GetNWBFileMetadata handler = new GetNWBFileMetadata();
        try {
            NWBFileParser parser = new NWBFileParser(nwbFile);
            parser.parse((NWBFileParserHandler)handler);
        }
        catch (IOException iOException) {
            return parameters;
        }
        catch (ParsingException parsingException) {
            return parameters;
        }
        try {
            definition = new BasicObjectClassDefinition(parameters.getID(), parameters.getName(), parameters.getDescription(), parameters.getIcon(16));
        }
        catch (IOException iOException) {
            definition = new BasicObjectClassDefinition(parameters.getID(), parameters.getName(), parameters.getDescription(), null);
        }
        String[] edgeAttributesArray = WeightedPagerankFactory.findLikelyWeightColumns(handler.getDirectedEdgeSchema());
        AttributeDefinition[] definitions = parameters.getAttributeDefinitions(-1);
        definition.addAttributeDefinition(1, (AttributeDefinition)new BasicAttributeDefinition(WEIGHT_ID, "Weight Attribute", "The attribute to use for weight", 1, edgeAttributesArray, edgeAttributesArray));
        AttributeDefinition[] attributeDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDefinition attributeDefinition = attributeDefinitionArray[n2];
            definition.addAttributeDefinition(1, attributeDefinition);
            ++n2;
        }
        return definition;
    }
}

