/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.sampling.common;

import edu.iu.nwb.analysis.sampling.common.JungSampler;
import edu.uci.ics.jung.graph.Graph;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public abstract class JungAlgorithmFactory
implements AlgorithmFactory {
    public Algorithm createAlgorithm(Data[] dm, Dictionary parameters, CIShellContext context) {
        return new SamplingAlgorithm(dm, parameters, context, this.getSampler());
    }

    protected abstract JungSampler getSampler();

    private class SamplingAlgorithm
    implements Algorithm {
        Data[] dm;
        Dictionary parameters;
        CIShellContext ciContext;
        private JungSampler sampler;

        public SamplingAlgorithm(Data[] dm, Dictionary parameters, CIShellContext ciContext, JungSampler sampler) {
            this.dm = dm;
            this.parameters = parameters;
            this.ciContext = ciContext;
            this.sampler = sampler;
        }

        public Data[] execute() {
            Graph graph = (Graph)this.dm[0].getData();
            Graph outputGraph = this.sampler.sample(graph, this.parameters);
            BasicData outputData = new BasicData((Object)outputGraph, Graph.class.getName());
            Dictionary map = outputData.getMetadata();
            map.put("Modified", new Boolean(true));
            map.put("Parent", this.dm[0]);
            map.put("Type", "Network");
            map.put("Label", this.sampler.getSampleName());
            return new Data[]{outputData};
        }
    }
}

