/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.sampling.edge;

import edu.iu.nwb.analysis.sampling.common.JungSampler;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Random;

public class EdgeSampler
implements JungSampler {
    private static final String NUMBER_PARAMETER_KEY = "edges";

    @Override
    public Graph sample(Graph graph, Dictionary parameters) {
        int totalNeeded = (Integer)parameters.get(NUMBER_PARAMETER_KEY);
        ArrayList edges = new ArrayList(graph.getEdges());
        Random randomizer = new Random();
        HashSet sampledEdges = new HashSet();
        while (edges.size() > 0 && sampledEdges.size() < totalNeeded) {
            sampledEdges.add(edges.remove(randomizer.nextInt(edges.size())));
        }
        return GraphUtils.edgeSetToGraph(sampledEdges, (boolean)false);
    }

    @Override
    public String getSampleName() {
        return "Edge Sample";
    }
}

