/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.sampling.node;

import edu.iu.nwb.analysis.sampling.common.JungSampler;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.filters.impl.DropSoloNodesFilter;
import edu.uci.ics.jung.utils.GraphUtils;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Random;

public class NodeSampler
implements JungSampler {
    private static final String NUMBER_PARAMETER_KEY = "nodes";

    @Override
    public Graph sample(Graph graph, Dictionary parameters) {
        int totalNeeded = (Integer)parameters.get(NUMBER_PARAMETER_KEY);
        ArrayList vertices = new ArrayList(graph.getVertices());
        Random randomizer = new Random();
        HashSet sampledVertices = new HashSet();
        while (vertices.size() > 0 && sampledVertices.size() < totalNeeded) {
            sampledVertices.add(vertices.remove(randomizer.nextInt(vertices.size())));
        }
        Graph sampledGraph = GraphUtils.vertexSetToGraph(sampledVertices);
        return DropSoloNodesFilter.getInstance().filter(sampledGraph).assemble();
    }

    @Override
    public String getSampleName() {
        return "Node Sample";
    }
}

