/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.selfloops;

import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.util.TableIterator;

public class Remove
implements Algorithm {
    Data[] data;
    Dictionary parameters;
    CIShellContext context;

    public Remove(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
    }

    public Data[] execute() {
        Graph graph = (Graph)this.data[0].getData();
        Table nodeTable = graph.getNodeTable().getSchema().instantiate();
        Table edgeTable = graph.getEdgeTable().getSchema().instantiate();
        String sourceField = graph.getEdgeSourceField();
        String targetField = graph.getEdgeTargetField();
        TableIterator nodes = graph.getNodeTable().iterator();
        while (nodes.hasNext()) {
            nodeTable.addTuple(graph.getNodeTable().getTuple(((Integer)nodes.next()).intValue()));
        }
        TableIterator edges = graph.getEdgeTable().iterator();
        while (edges.hasNext()) {
            Tuple tuple = graph.getEdgeTable().getTuple(((Integer)edges.next()).intValue());
            if (tuple.get(sourceField).equals(tuple.get(targetField))) continue;
            edgeTable.addTuple(tuple);
        }
        Graph resultGraph = new Graph(nodeTable, edgeTable, graph.isDirected(), graph.getNodeKeyField(), graph.getEdgeSourceField(), graph.getEdgeTargetField());
        BasicData result = new BasicData((Object)resultGraph, Graph.class.getName());
        Dictionary metadata = result.getMetadata();
        metadata.put("Label", "Without self loops");
        metadata.put("Parent", this.data[0]);
        metadata.put("Type", "Network");
        return new Data[]{result};
    }
}

