/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.analysis.weakcomponentclustering;

import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Graph;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;

public class ClusteringAlgorithm
implements Algorithm {
    private Data[] data;
    private Dictionary parameters;
    private CIShellContext context;

    public ClusteringAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.data = data;
        this.parameters = parameters;
        this.context = context;
    }

    public Data[] execute() {
        LogService log = (LogService)this.context.getService(LogService.class.getName());
        Graph inputGraph = (Graph)this.data[0].getData();
        ClusterSet clusters = new WeakComponentClusterer().extract((ArchetypeGraph)inputGraph);
        clusters.sort();
        int desiredClusters = (Integer)this.parameters.get("n");
        int totalClusters = desiredClusters == 0 || desiredClusters > clusters.size() ? clusters.size() : desiredClusters;
        log.log(3, clusters.size() + " clusters found, generating graphs for the top " + totalClusters + " clusters.");
        Data[] output = new Data[totalClusters];
        int clusterIndex = 0;
        while (clusterIndex < totalClusters) {
            Graph cluster = clusters.getClusterAsNewSubGraph(clusterIndex);
            output[clusterIndex] = new BasicData((Object)cluster, Graph.class.getName());
            Dictionary attributes = output[clusterIndex].getMetadata();
            attributes.put("Modified", new Boolean(true));
            attributes.put("Parent", this.data[0]);
            attributes.put("Type", "Network");
            attributes.put("Label", "Weak Component Cluster of " + cluster.numVertices() + " nodes");
            ++clusterIndex;
        }
        return output;
    }
}

