/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.composite.extractpapercitationnetwork.algorithm;

import edu.iu.nwb.analysis.extractnetfromtable.components.ExtractNetworkFromTable;
import edu.iu.nwb.analysis.extractnetfromtable.components.GraphContainer;
import edu.iu.nwb.analysis.extractnetfromtable.components.InvalidColumnNameException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Properties;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.ProgressMonitor;
import org.cishell.framework.algorithm.ProgressTrackable;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.osgi.service.log.LogService;
import prefuse.data.Graph;
import prefuse.data.Table;

public class ExtractPaperCitationNetwork
implements Algorithm,
ProgressTrackable {
    public static final String ISI_FILE_TYPE = "isi";
    public static final String PAPER_COLUMN_NAME = "Cite Me As";
    public static final String CITATION_COLUMN_NAME = "Cited References";
    private Data[] data;
    private LogService logger;
    private ProgressMonitor progressMonitor;

    public ExtractPaperCitationNetwork(Data[] data, CIShellContext context) {
        this.data = data;
        this.logger = (LogService)context.getService(LogService.class.getName());
    }

    public Data[] execute() throws AlgorithmExecutionException {
        Table inTable = (Table)this.data[0].getData();
        String fileFormatPropertiesFile = this.getFileTypeProperties(ISI_FILE_TYPE);
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream fileTypePropertiesFile = loader.getResourceAsStream(fileFormatPropertiesFile);
        Properties metaData = new Properties();
        try {
            metaData.load(fileTypePropertiesFile);
        }
        catch (FileNotFoundException e) {
            this.logger.log(1, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.log(1, e.getMessage(), (Throwable)e);
        }
        try {
            GraphContainer gc = GraphContainer.initializeGraph((Table)inTable, (String)CITATION_COLUMN_NAME, (String)PAPER_COLUMN_NAME, (boolean)true, (Properties)metaData, (LogService)this.logger, (ProgressMonitor)this.progressMonitor);
            Graph outputGraph = gc.buildGraph(CITATION_COLUMN_NAME, PAPER_COLUMN_NAME, "|", false, this.logger);
            Data outputGraphData = this.createOutputGraphData(outputGraph);
            Table outputTable = ExtractNetworkFromTable.constructTable((Graph)outputGraph);
            Data outputTableData = this.createOutputTableData(outputTable);
            return new Data[]{outputGraphData, outputTableData};
        }
        catch (InvalidColumnNameException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (GraphContainer.PropertyParsingException e) {
            throw new AlgorithmExecutionException((Throwable)e);
        }
    }

    private Data createOutputTableData(Table outputTable) {
        BasicData outputTableData = new BasicData((Object)outputTable, Table.class.getName());
        Dictionary tableAttributes = outputTableData.getMetadata();
        tableAttributes.put("Modified", new Boolean(true));
        tableAttributes.put("Parent", this.data[0]);
        tableAttributes.put("Type", "Matrix");
        tableAttributes.put("Label", "Paper information");
        return outputTableData;
    }

    private Data createOutputGraphData(Graph outputGraph) {
        BasicData outputGraphData = new BasicData((Object)outputGraph, Graph.class.getName());
        Dictionary graphAttributes = outputGraphData.getMetadata();
        graphAttributes.put("Modified", new Boolean(true));
        graphAttributes.put("Parent", this.data[0]);
        graphAttributes.put("Type", "Network");
        graphAttributes.put("Label", "Extracted paper-citation network");
        return outputGraphData;
    }

    private String getFileTypeProperties(String fileType) {
        String propertiesFileName = "/edu/iu/nwb/composite/extractpapercitationnetwork/metadata/";
        return String.valueOf(propertiesFileName) + fileType + ".properties";
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }
}

