/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.edgelist.common;

import edu.iu.nwb.converter.edgelist.common.EdgeSectionWriter;
import edu.iu.nwb.converter.edgelist.common.InvalidEdgeListFormatException;
import edu.iu.nwb.converter.edgelist.common.NodeSectionWriter;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.utilities.FileUtilities;

public class EdgeListParser {
    public static final String DIRECTED_REGEX = "^\\s*directed\\s*$";
    public static final String UNDIRECTED_REGEX = "^\\s*undirected\\s*$";
    public static final String LINE_ONLY_WHITESPACE_REGEX = "^\\s*$";
    public static final String SINGLE_OR_DOUBLE_QUOTE_REGEX = "['\"]";
    private static final String NODE_WITH_NO_QUOTES_REGEX = "[\\w_]+";
    private static final String NODE_WITH_QUOTES_REGEX = "(\"[^\"]+\")|('[^']+')";
    private static final String ANY_NODE_REGEX = "([\\w_]+|(\"[^\"]+\")|('[^']+'))";
    private static final String OPTIONAL_WEIGHT_REGEX = "(\\s+[+-]?(([0-9]+)?\\.)?[0-9]+)?";
    private static final String EDGE_PATTERN_REGEX = "([\\w_]+|(\"[^\"]+\")|('[^']+'))\\s+([\\w_]+|(\"[^\"]+\")|('[^']+'))(\\s+[+-]?(([0-9]+)?\\.)?[0-9]+)?";
    public static final Pattern EDGE_PATTERN = Pattern.compile("([\\w_]+|(\"[^\"]+\")|('[^']+'))\\s+([\\w_]+|(\"[^\"]+\")|('[^']+'))(\\s+[+-]?(([0-9]+)?\\.)?[0-9]+)?");
    public static final int SOURCE_NODE_INDEX = 1;
    public static final int TARGET_NODE_INDEX = 4;
    public static final int EDGE_WEIGHT_INDEX = 7;
    private File edgeListFile;
    private boolean validateOnly;

    public EdgeListParser(File edgeListFile) {
        this(edgeListFile, false);
    }

    public EdgeListParser(File edgeListFile, boolean validateOnly) {
        this.edgeListFile = edgeListFile;
        this.validateOnly = validateOnly;
    }

    public void parseInto(NWBFileParserHandler writer) throws InvalidEdgeListFormatException, IOException, AlgorithmExecutionException {
        if (FileUtilities.isFileEmpty((File)this.edgeListFile)) {
            throw new InvalidEdgeListFormatException("The input file was empty.");
        }
        NodeSectionWriter nodeSectionWriter = new NodeSectionWriter(writer);
        nodeSectionWriter.write(this.edgeListFile, this.validateOnly);
        Map nodeNameToID = nodeSectionWriter.getNodeNameToIDMap();
        EdgeSectionWriter edgeSectionWriter = new EdgeSectionWriter(writer, nodeNameToID);
        edgeSectionWriter.write(this.edgeListFile, this.validateOnly);
        writer.finishedParsing();
    }

    protected static boolean isValidEdgeLine(String line) {
        return EDGE_PATTERN.matcher(line).matches();
    }

    protected static String stripAllQuoteCharacters(String originalString) {
        return originalString.replaceAll(SINGLE_OR_DOUBLE_QUOTE_REGEX, "");
    }
}

