/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.edgelist.common;

import edu.iu.nwb.converter.edgelist.common.EdgeListParser;
import edu.iu.nwb.converter.edgelist.common.InvalidEdgeListFormatException;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.utilities.UnicodeReader;

public class EdgeSectionWriter {
    private NWBFileParserHandler writer;
    private final Map nodeNameToID;
    public static final String WEIGHT_NWB_ATTRIBUTE_KEY = "weight";
    public static final boolean IS_DIRECTED_DEFAULT = false;

    public EdgeSectionWriter(NWBFileParserHandler writer, Map nodeNameToID) {
        this.writer = writer;
        this.nodeNameToID = nodeNameToID;
    }

    public void write(File edgeListFile, boolean validateOnly) throws InvalidEdgeListFormatException, IOException, AlgorithmExecutionException {
        boolean isWeighted = this.findWeightedness(edgeListFile);
        boolean isDirected = this.isDirected(edgeListFile);
        this.writeEdgeSectionHeader(isWeighted, isDirected);
        BufferedReader edgeReader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(edgeListFile)));
        String line = edgeReader.readLine();
        if (line.matches("^\\s*undirected\\s*$") || line.matches("^\\s*directed\\s*$")) {
            line = edgeReader.readLine();
        }
        while (line != null) {
            if (!line.matches("^\\s*$")) {
                if (EdgeListParser.isValidEdgeLine(line)) {
                    if (!validateOnly) {
                        this.writeEdgeOnLine(line, isDirected);
                    }
                } else {
                    String errorMessage = "The line \n\t" + line + "\n was invalid.";
                    throw new InvalidEdgeListFormatException(errorMessage);
                }
            }
            line = edgeReader.readLine();
        }
        edgeReader.close();
    }

    private void writeEdgeSectionHeader(boolean isWeighted, boolean isDirected) {
        LinkedHashMap<String, String> edgeSchema = new LinkedHashMap<String, String>();
        edgeSchema.put("source", "int");
        edgeSchema.put("target", "int");
        if (isWeighted) {
            edgeSchema.put(WEIGHT_NWB_ATTRIBUTE_KEY, "float");
        }
        if (isDirected) {
            this.writer.setDirectedEdgeSchema(edgeSchema);
        } else {
            this.writer.setUndirectedEdgeSchema(edgeSchema);
        }
    }

    private void writeEdgeOnLine(String line, boolean isDirected) throws AlgorithmExecutionException {
        Matcher tokens = EdgeListParser.EDGE_PATTERN.matcher(line);
        tokens.matches();
        String sourceName = tokens.group(1);
        int sourceID = this.getNodeIDFromName(sourceName);
        String targetName = tokens.group(4);
        int targetID = this.getNodeIDFromName(targetName);
        String weight = tokens.group(7);
        HashMap<String, Double> attributes = new HashMap<String, Double>();
        if (weight != null) {
            attributes.put(WEIGHT_NWB_ATTRIBUTE_KEY, Double.valueOf(weight));
        }
        if (isDirected) {
            this.writer.addDirectedEdge(sourceID, targetID, attributes);
        } else {
            this.writer.addUndirectedEdge(sourceID, targetID, attributes);
        }
    }

    private boolean isDirected(File edgeListFile) throws IOException, InvalidEdgeListFormatException {
        BufferedReader edgeReader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(edgeListFile)));
        String firstLine = edgeReader.readLine();
        edgeReader.close();
        if (firstLine.matches("^\\s*directed\\s*$")) {
            return true;
        }
        if (firstLine.matches("^\\s*undirected\\s*$")) {
            return false;
        }
        return false;
    }

    private boolean findWeightedness(File edgeListFile) throws InvalidEdgeListFormatException, IOException {
        BufferedReader edgeReader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(edgeListFile)));
        String line = edgeReader.readLine();
        if (line.matches("^\\s*undirected\\s*$") || line.matches("^\\s*directed\\s*$")) {
            line = edgeReader.readLine();
        }
        while (line != null) {
            if (!line.matches("^\\s*$")) {
                Matcher edgeLineMatcher = EdgeListParser.EDGE_PATTERN.matcher(line);
                if (edgeLineMatcher.matches()) {
                    edgeReader.close();
                    String weight = edgeLineMatcher.group(7);
                    return weight != null;
                }
                String message = "The line \n\t" + line + "\n was invalid.";
                throw new InvalidEdgeListFormatException(message);
            }
            line = edgeReader.readLine();
        }
        edgeReader.close();
        return false;
    }

    private int getNodeIDFromName(String possiblyQuotedName) throws AlgorithmExecutionException {
        String name = EdgeListParser.stripAllQuoteCharacters(possiblyQuotedName);
        if (this.nodeNameToID.containsKey(name)) {
            int nodeID = (Integer)this.nodeNameToID.get(name);
            return nodeID;
        }
        String message = "Node name didn't have a corresponding ID.";
        throw new AlgorithmExecutionException(message);
    }
}

