/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.edgelist.common;

import edu.iu.nwb.converter.edgelist.common.EdgeListParser;
import edu.iu.nwb.converter.edgelist.common.InvalidEdgeListFormatException;
import edu.iu.nwb.util.nwbfile.NWBFileParserHandler;
import edu.iu.nwb.util.nwbfile.NWBFileProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.utilities.UnicodeReader;

public class NodeSectionWriter {
    public static final int FIRST_NODE_ID = 1;
    private NWBFileParserHandler writer;
    private final Map nodeNameToID;
    private int nextAvailableNodeID;

    public NodeSectionWriter(NWBFileParserHandler writer) {
        this.writer = writer;
        this.nodeNameToID = new HashMap();
        this.nextAvailableNodeID = 1;
    }

    public void write(File edgeListFile, boolean validateOnly) throws InvalidEdgeListFormatException, IOException, AlgorithmExecutionException {
        this.writer.setNodeSchema(NWBFileProperty.NECESSARY_NODE_ATTRIBUTES);
        BufferedReader edgeReader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(edgeListFile)));
        String line = edgeReader.readLine();
        if (line.matches("^\\s*undirected\\s*$") || line.matches("^\\s*directed\\s*$")) {
            line = edgeReader.readLine();
        }
        while (line != null) {
            if (!line.matches("^\\s*$")) {
                Matcher edgeLineMatcher = EdgeListParser.EDGE_PATTERN.matcher(line);
                if (edgeLineMatcher.matches()) {
                    if (!validateOnly) {
                        this.writeNodesOnLine(edgeLineMatcher);
                    }
                } else {
                    String message = "The line \n\t" + line + "\n was invalid.";
                    throw new InvalidEdgeListFormatException(message);
                }
            }
            line = edgeReader.readLine();
        }
        edgeReader.close();
    }

    public Map getNodeNameToIDMap() {
        return this.nodeNameToID;
    }

    private void writeNodesOnLine(Matcher edgeLineMatcher) throws AlgorithmExecutionException {
        if (!edgeLineMatcher.matches()) {
            throw new AlgorithmExecutionException("Cannot read edge data from an invalid EdgeList edge line.");
        }
        String sourceToken = edgeLineMatcher.group(1);
        this.writeNodeIfNew(sourceToken);
        String targetToken = edgeLineMatcher.group(4);
        this.writeNodeIfNew(targetToken);
    }

    private void writeNodeIfNew(String possiblyQuotedNodeName) {
        String nodeName = EdgeListParser.stripAllQuoteCharacters(possiblyQuotedNodeName);
        if (!this.nodeNameToID.containsKey(nodeName)) {
            int nodeID = this.nextAvailableNodeID++;
            this.nodeNameToID.put(nodeName, new Integer(nodeID));
            this.writer.addNode(nodeID, nodeName, new HashMap());
        }
    }
}

