/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.jungprefuse;

import edu.berkeley.guir.prefuse.graph.DefaultEdge;
import edu.berkeley.guir.prefuse.graph.DefaultGraph;
import edu.berkeley.guir.prefuse.graph.DefaultNode;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class JungPrefuseConverter {
    public static JungGraph getPrefuseGraph(Graph g) {
        boolean isDirected = false;
        HashMap<Vertex, JungNode> jungToPrefuseVertices = new HashMap<Vertex, JungNode>();
        for (Vertex v : g.getVertices()) {
            jungToPrefuseVertices.put(v, new JungNode(v));
        }
        for (Edge e : g.getEdges()) {
            JungNode node1 = (JungNode)((Object)jungToPrefuseVertices.get(e.getEndpoints().getFirst()));
            JungNode node2 = (JungNode)((Object)jungToPrefuseVertices.get(e.getEndpoints().getSecond()));
            boolean directedEdge = Graph.DIRECTED_EDGE.evaluate((Object)e);
            if (directedEdge) {
                isDirected = true;
            }
            JungEdge edgeOut = new JungEdge(e, (Node)node1, (Node)node2, directedEdge);
            node1.addEdge((edu.berkeley.guir.prefuse.graph.Edge)edgeOut);
        }
        JungGraph rv = new JungGraph(g, jungToPrefuseVertices.values(), isDirected);
        return rv;
    }

    public static class JungEdge
    extends DefaultEdge {
        public final Edge jungEdge;

        public JungEdge(Edge jungEdge, Node n1, Node n2, boolean directed) {
            super(n1, n2, directed);
            this.jungEdge = jungEdge;
            Iterator it = jungEdge.getUserDatumKeyIterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object value = jungEdge.getUserDatum(key);
                key = key == null ? null : key.toString();
                value = value == null ? null : value.toString();
                this.setAttribute((String)key, (String)value);
            }
        }
    }

    public static class JungGraph
    extends DefaultGraph {
        public final Graph jungGraph;

        public JungGraph(Graph g, Collection collection, boolean b) {
            super(collection, b);
            this.jungGraph = g;
        }
    }

    public static class JungNode
    extends DefaultNode {
        public final Vertex jungVertex;

        public JungNode(Vertex v) {
            this.jungVertex = v;
            Iterator it = v.getUserDatumKeyIterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object value = v.getUserDatum(key);
                key = key == null ? null : key.toString();
                value = value == null ? null : value.toString();
                this.setAttribute((String)key, (String)value);
            }
        }
    }
}

