/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.jungprefuse;

import edu.berkeley.guir.prefuse.graph.Entity;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.graph.Node;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PrefuseJungConverter {
    public static edu.uci.ics.jung.graph.Graph getJungGraph(Graph prefuseGraph) {
        boolean directed = prefuseGraph.isDirected();
        Object jungGraph = directed ? new DirectedSparseGraph() : new UndirectedSparseGraph();
        HashMap<Node, SparseVertex> nodeVertexMap = new HashMap<Node, SparseVertex>();
        Iterator nodes = prefuseGraph.getNodes();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            SparseVertex vertex = new SparseVertex();
            PrefuseJungConverter.merge((Entity)node, (UserDataContainer)vertex);
            jungGraph.addVertex((Vertex)vertex);
            nodeVertexMap.put(node, vertex);
        }
        Iterator prefuseEdges = prefuseGraph.getEdges();
        while (prefuseEdges.hasNext()) {
            edu.berkeley.guir.prefuse.graph.Edge prefuseEdge = (edu.berkeley.guir.prefuse.graph.Edge)prefuseEdges.next();
            Vertex first = (Vertex)nodeVertexMap.get(prefuseEdge.getFirstNode());
            Vertex second = (Vertex)nodeVertexMap.get(prefuseEdge.getSecondNode());
            Object jungEdge = directed ? new DirectedSparseEdge(first, second) : new UndirectedSparseEdge(first, second);
            PrefuseJungConverter.merge((Entity)prefuseEdge, (UserDataContainer)jungEdge);
            jungGraph.addEdge((Edge)jungEdge);
        }
        return jungGraph;
    }

    private static void merge(Entity prefuseEntity, UserDataContainer jungContainer) {
        Map attributes = prefuseEntity.getAttributes();
        for (Object key : attributes.keySet()) {
            jungContainer.addUserDatum(key, attributes.get(key), UserData.SHARED);
        }
    }
}

