/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.jungprefusebeta;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.PredicateUtils;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.HashMap;
import java.util.Iterator;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Tuple;

public class JungPrefuseBetaConverter {
    private Graph prefuseGraph;

    public Graph getPrefuseGraph(edu.uci.ics.jung.graph.Graph jungGraph) {
        HashMap<Vertex, Node> jungToPrefuseVertices = new HashMap<Vertex, Node>();
        this.prefuseGraph = new Graph(PredicateUtils.enforcesDirected((edu.uci.ics.jung.graph.Graph)jungGraph));
        for (Vertex vertex : jungGraph.getVertices()) {
            Node node = this.prefuseGraph.addNode();
            this.merge((UserDataContainer)vertex, (Tuple)node);
            jungToPrefuseVertices.put(vertex, node);
        }
        for (Edge e : jungGraph.getEdges()) {
            Node first = (Node)jungToPrefuseVertices.get(e.getEndpoints().getFirst());
            Node second = (Node)jungToPrefuseVertices.get(e.getEndpoints().getSecond());
            prefuse.data.Edge edge = this.prefuseGraph.addEdge(first, second);
            this.merge((UserDataContainer)e, (Tuple)edge);
        }
        return this.prefuseGraph;
    }

    private void merge(UserDataContainer jungContainer, Tuple prefuseTuple) {
        Iterator keys = jungContainer.getUserDatumKeyIterator();
        while (keys.hasNext()) {
            Object datum;
            Class<?> metadataClass;
            Object realKey = keys.next();
            String key = realKey.toString();
            if (!prefuseTuple.canSet(key, metadataClass = (datum = jungContainer.getUserDatum(realKey)).getClass())) {
                prefuseTuple.getTable().addColumn(key, metadataClass);
            }
            if ("target".equals(key) || "source".equals(key)) continue;
            prefuseTuple.set(key, datum);
        }
    }
}

