/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.jungprefusebeta;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SimpleSparseVertex;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Tuple;

public class PrefuseBetaJungConverter {
    private edu.uci.ics.jung.graph.Graph jungGraph;

    public edu.uci.ics.jung.graph.Graph getJungGraph(Graph prefuseGraph) {
        HashMap<Node, SimpleSparseVertex> prefuseToJungVertices = new HashMap<Node, SimpleSparseVertex>();
        boolean directed = prefuseGraph.isDirected();
        HashSet<Predicate> constraints = new HashSet<Predicate>();
        if (directed) {
            constraints.add(edu.uci.ics.jung.graph.Graph.DIRECTED_EDGE);
        } else {
            constraints.add(edu.uci.ics.jung.graph.Graph.UNDIRECTED_EDGE);
        }
        this.jungGraph = new SparseGraph(constraints);
        Iterator iter = prefuseGraph.nodes();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            SimpleSparseVertex vertex = new SimpleSparseVertex();
            this.merge((Tuple)node, (UserDataContainer)vertex);
            this.jungGraph.addVertex((Vertex)vertex);
            prefuseToJungVertices.put(node, vertex);
        }
        iter = prefuseGraph.edges();
        while (iter.hasNext()) {
            prefuse.data.Edge e = (prefuse.data.Edge)iter.next();
            Vertex first = (Vertex)prefuseToJungVertices.get(e.getSourceNode());
            Vertex second = (Vertex)prefuseToJungVertices.get(e.getTargetNode());
            Object edge = directed ? new DirectedSparseEdge(first, second) : new UndirectedSparseEdge(first, second);
            this.merge((Tuple)e, (UserDataContainer)edge);
            this.jungGraph.addEdge((Edge)edge);
        }
        return this.jungGraph;
    }

    private void merge(Tuple prefuseTuple, UserDataContainer jungContainer) {
        Schema schema = prefuseTuple.getSchema();
        int columns = schema.getColumnCount();
        int ii = 0;
        while (ii < columns) {
            if (prefuseTuple.get(ii) != null) {
                jungContainer.addUserDatum((Object)schema.getColumnName(ii), prefuseTuple.get(ii), UserData.SHARED);
            }
            ++ii;
        }
    }
}

