/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.nwb.common;

import edu.iu.nwb.converter.nwb.common.NWBAttribute;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.utilities.UnicodeReader;

public class ValidateNWBFile {
    private boolean hasHeader_Nodes = false;
    private boolean hasHeader_UndirectedEdges = false;
    private boolean hasHeader_DirectedEdges = false;
    private boolean isFileGood = true;
    private boolean inNodesSection = false;
    private boolean inUndirectededgesSection = false;
    private boolean inDirectededgesSection = false;
    private boolean hasTotalNumOfNodes = false;
    private boolean passHeader = false;
    private int totalNumOfNodes;
    private int currentLine;
    private int countedNumDirected;
    private int countedNumUnDirected;
    private int countedNodes;
    private StringBuffer errorMessages = new StringBuffer();
    private List nodeAttrList;
    private List directedEdgeAttrList;
    private List undirectedEdgeAttrList;

    public void validateNWBFormat(File fileHandler) throws FileNotFoundException, IOException {
        this.currentLine = 0;
        this.countedNumDirected = 0;
        this.countedNumUnDirected = 0;
        this.countedNodes = 0;
        BufferedReader reader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(fileHandler)));
        this.processFile(reader);
    }

    private void processFile(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && this.isFileGood) {
            ++this.currentLine;
            if ((line = line.trim()).startsWith("#") || line.length() <= 0) {
                line = reader.readLine();
                continue;
            }
            if (this.validateNodeHeader(line)) {
                line = reader.readLine();
                continue;
            }
            if (this.validateDirectedEdgeHeader(line)) {
                line = reader.readLine();
                continue;
            }
            if (this.validateUndirectedEdgeHeader(line)) {
                line = reader.readLine();
                continue;
            }
            if (this.inNodesSection && this.isFileGood) {
                this.processNodes(line);
                line = reader.readLine();
                continue;
            }
            if (this.inDirectededgesSection && this.isFileGood) {
                this.processDirectedEdges(line);
                line = reader.readLine();
                continue;
            }
            if (this.inUndirectededgesSection && this.isFileGood) {
                this.processUndirectedEdges(line);
                line = reader.readLine();
                continue;
            }
            line = reader.readLine();
        }
        if (this.isFileGood) {
            this.checkFile();
        }
        if (this.hasTotalNumOfNodes && this.countedNodes != this.totalNumOfNodes) {
            this.errorMessages.append("There was an inconsistency between the specified number of nodes: " + this.totalNumOfNodes + " and the " + "number of nodes counted: " + this.countedNodes);
        }
        this.totalNumOfNodes = this.countedNodes;
    }

    private void checkFile() {
        if (!this.hasHeader_Nodes) {
            this.isFileGood = false;
            this.errorMessages.append("*The file does not specify the node header.\n\n");
        } else if (!this.hasHeader_DirectedEdges && !this.hasHeader_UndirectedEdges) {
            this.isFileGood = false;
            this.errorMessages.append("This file has not specified a valid edge header.");
        }
    }

    private boolean validateNodeHeader(String s) {
        if (s.startsWith("*Nodes")) {
            this.hasHeader_Nodes = true;
            this.inNodesSection = true;
            this.inDirectededgesSection = false;
            this.inUndirectededgesSection = false;
            this.passHeader = true;
            this.nodeAttrList = new ArrayList();
            StringTokenizer st = new StringTokenizer(s);
            if (st.countTokens() > 1) {
                st.nextToken();
                this.totalNumOfNodes = new Integer(st.nextToken());
                this.hasTotalNumOfNodes = true;
            } else {
                this.hasTotalNumOfNodes = false;
            }
            return true;
        }
        if (s.equalsIgnoreCase("*Nodes")) {
            this.isFileGood = false;
            this.errorMessages.append("The header of the node section in an nwb file should be *Nodes and it is case sensitive. The current header is " + s + ".\n\n");
            return false;
        }
        return false;
    }

    private boolean validateDirectedEdgeHeader(String s) {
        if (s.startsWith("*DirectedEdges")) {
            this.hasHeader_DirectedEdges = true;
            this.inDirectededgesSection = true;
            this.inNodesSection = false;
            this.inUndirectededgesSection = false;
            this.passHeader = true;
            this.directedEdgeAttrList = new ArrayList();
            return true;
        }
        if (s.equalsIgnoreCase("*DirectedEdges")) {
            this.isFileGood = false;
            this.errorMessages.append("The header of the directed edge section should be *DirectedEdges and it is case sensitive. The current header is " + s + ".\n\n");
            return false;
        }
        return false;
    }

    private boolean validateUndirectedEdgeHeader(String s) {
        if (s.startsWith("*UndirectedEdges")) {
            this.hasHeader_UndirectedEdges = true;
            this.inUndirectededgesSection = true;
            this.inNodesSection = false;
            this.inDirectededgesSection = false;
            this.passHeader = true;
            this.undirectedEdgeAttrList = new ArrayList();
            return true;
        }
        if (s.equalsIgnoreCase("*UndirectedEdges")) {
            this.isFileGood = false;
            this.errorMessages.append("The header of the undirected edge section should be *UndirectedEdges and it is case sensitive. The current header is " + s + ".\n\n");
            return false;
        }
        return false;
    }

    private void processNodes(String s) {
        if (this.passHeader) {
            if (s.startsWith("id")) {
                StringTokenizer st = new StringTokenizer(s);
                int totalTokens = st.countTokens();
                int i = 1;
                while (i <= totalTokens) {
                    try {
                        NWBAttribute attr = this.processAttrToken(st.nextToken());
                        this.nodeAttrList.add(attr);
                    }
                    catch (Exception e) {
                        this.isFileGood = false;
                        this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
                        break;
                    }
                    ++i;
                }
            } else {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ". The attribute line is missing.\n\n");
            }
            this.passHeader = false;
        } else {
            try {
                this.validateALine(s, this.nodeAttrList);
                ++this.countedNodes;
            }
            catch (Exception e) {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
            }
        }
    }

    private void processDirectedEdges(String s) {
        if (this.passHeader) {
            if (s.startsWith("source")) {
                StringTokenizer st = new StringTokenizer(s);
                int tokens = st.countTokens();
                int i = 1;
                while (i <= tokens) {
                    String token = st.nextToken();
                    try {
                        NWBAttribute attr = this.processAttrToken(token);
                        this.directedEdgeAttrList.add(attr);
                    }
                    catch (Exception e) {
                        this.isFileGood = false;
                        this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
                        break;
                    }
                    ++i;
                }
            } else {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + "The attribute line is missing.\n\n");
            }
            this.passHeader = false;
        } else {
            try {
                this.validateALine(s, this.directedEdgeAttrList);
                ++this.countedNumDirected;
            }
            catch (Exception e) {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
            }
        }
    }

    private void processUndirectedEdges(String s) {
        if (this.passHeader) {
            if (s.startsWith("source")) {
                StringTokenizer st = new StringTokenizer(s);
                int tokens = st.countTokens();
                int i = 1;
                while (i <= tokens) {
                    String token = st.nextToken();
                    try {
                        NWBAttribute attr = this.processAttrToken(token);
                        this.undirectedEdgeAttrList.add(attr);
                    }
                    catch (Exception e) {
                        this.isFileGood = false;
                        this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
                        break;
                    }
                    ++i;
                }
            } else {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + "The attribute line is missing.\n\n");
            }
            this.passHeader = false;
        } else {
            try {
                this.validateALine(s, this.undirectedEdgeAttrList);
                ++this.countedNumUnDirected;
            }
            catch (Exception e) {
                this.isFileGood = false;
                this.errorMessages.append("*Wrong NWB format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
            }
        }
    }

    private boolean validateALine(String line, List attrList) throws AlgorithmExecutionException {
        if (line.length() <= 0 || line.startsWith("#")) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(line);
        int totalTokens = st.countTokens();
        if (totalTokens <= 0) {
            return true;
        }
        if (totalTokens < attrList.size()) {
            throw new AlgorithmExecutionException("Did not specify all values for defined attributes!");
        }
        String[] columns = this.processTokens(st);
        int ii = 0;
        while (ii < attrList.size()) {
            NWBAttribute nwbAttr = (NWBAttribute)attrList.get(ii);
            String dt = nwbAttr.getDataType();
            if (!columns[ii].equalsIgnoreCase("*")) {
                if (dt.equalsIgnoreCase("string")) {
                    this.isAString(columns[ii], nwbAttr.getAttrName());
                } else if (dt.equalsIgnoreCase("int")) {
                    this.isAnInteger(columns[ii], nwbAttr.getAttrName());
                } else if (dt.equalsIgnoreCase("float") || dt.equalsIgnoreCase("real")) {
                    this.isAFloat(columns[ii], nwbAttr.getAttrName());
                }
            }
            ++ii;
        }
        return true;
    }

    private boolean isAnInteger(String input, String attr) throws NumberFormatException, AlgorithmExecutionException {
        Integer value = new Integer(input);
        if ((attr.equalsIgnoreCase("id") || attr.equalsIgnoreCase("source") || attr.equalsIgnoreCase("target")) && value < 1) {
            throw new AlgorithmExecutionException("The node id must be greater than 0.");
        }
        return true;
    }

    private boolean isAString(String input, String attr) throws AlgorithmExecutionException {
        if (!input.startsWith("\"") || !input.endsWith("\"")) {
            throw new AlgorithmExecutionException("A string value must be surrounded by double quatation marks.");
        }
        return true;
    }

    private boolean isAFloat(String input, String attr) throws NumberFormatException {
        Float f = new Float(input);
        f.floatValue();
        return true;
    }

    private NWBAttribute processAttrToken(String token) throws AlgorithmExecutionException {
        if (token.indexOf("*") != -1) {
            String attr_type;
            String attr_name = token.substring(0, token.indexOf("*"));
            if (attr_name.startsWith("//")) {
                attr_name = attr_name.substring(2);
            }
            if (!((attr_type = token.substring(token.indexOf("*") + 1)).equalsIgnoreCase("float") || attr_type.equalsIgnoreCase("real") || attr_type.equalsIgnoreCase("int") || attr_type.equalsIgnoreCase("string"))) {
                throw new AlgorithmExecutionException("The data type of the attribute " + attr_name + " is not acceptable. Only float, int and string are " + "valid data types in the NWB format.\n" + "You supplied an attribute of " + attr_type);
            }
            return new NWBAttribute(attr_name, attr_type);
        }
        throw new AlgorithmExecutionException("Cannot find * from attribute*datatype line.");
    }

    public String[] processTokens(StringTokenizer st) {
        int total = st.countTokens();
        int tokenIndex = 0;
        String[] tokens = new String[total];
        StringBuffer bf = new StringBuffer();
        boolean append = false;
        int index = 0;
        while (index < total) {
            String element = st.nextToken();
            if (!append) {
                if (!element.startsWith("\"")) {
                    tokens[tokenIndex] = element;
                    ++tokenIndex;
                } else if (element.startsWith("\"") && element.endsWith("\"") && !element.equals("\"")) {
                    tokens[tokenIndex] = element;
                    ++tokenIndex;
                } else {
                    append = true;
                    bf.append(element);
                }
            } else if (element.endsWith("\\\"") || !element.endsWith("\"")) {
                bf.append(" " + element);
            } else if (element.endsWith("\"")) {
                bf.append(" " + element);
                tokens[tokenIndex] = bf.toString();
                ++tokenIndex;
                bf = new StringBuffer();
                append = false;
            }
            ++index;
        }
        return tokens;
    }

    public boolean isDirectedGraph() {
        return this.hasHeader_DirectedEdges && this.directedEdgeAttrList.size() > 0;
    }

    public boolean isUndirectedGraph() {
        return this.hasHeader_UndirectedEdges && this.undirectedEdgeAttrList.size() > 0;
    }

    public boolean getValidationResult() {
        return this.isFileGood;
    }

    public String getErrorMessages() {
        return this.errorMessages.toString();
    }

    public List getNodeAttrList() {
        return this.nodeAttrList;
    }

    public List getUndirectedEdgeAttrList() {
        return this.undirectedEdgeAttrList;
    }

    public List getDirectedEdgeAttrList() {
        return this.directedEdgeAttrList;
    }

    public int getTotalNumOfNodes() {
        return this.totalNumOfNodes;
    }

    public boolean getHasTotalNumOfNodes() {
        return this.hasTotalNumOfNodes;
    }

    public int getTotalNumOfUndirectedEdges() {
        return this.countedNumUnDirected;
    }

    public int getTotalNumOfDirectedEdges() {
        return this.countedNumDirected;
    }
}

