/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.nwb.reader;

import edu.iu.nwb.converter.nwb.common.ValidateNWBFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class NWBValidation
implements AlgorithmFactory {
    public Algorithm createAlgorithm(Data[] dm, Dictionary parameters, CIShellContext context) {
        return new NWBValidationAlgorithm(dm, parameters, context);
    }

    public class NWBValidationAlgorithm
    implements Algorithm {
        private String inNWBFileName;

        public NWBValidationAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
            this.inNWBFileName = (String)data[0].getData();
        }

        public Data[] execute() throws AlgorithmExecutionException {
            File inData = new File(this.inNWBFileName);
            ValidateNWBFile validator = new ValidateNWBFile();
            try {
                validator.validateNWBFormat(inData);
                if (validator.getValidationResult()) {
                    return this.createOutData(inData);
                }
                throw new AlgorithmExecutionException("Sorry, your file does not comply with the NWB File Format Specification.\nPlease review the latest NWB File Format Specification at http://nwb.cns.iu.edu/doc.html and update your file. \n" + validator.getErrorMessages());
            }
            catch (FileNotFoundException e) {
                String message = "Error: Couldn't find NWB file to validate: " + e.getMessage();
                throw new AlgorithmExecutionException(message, (Throwable)e);
            }
            catch (IOException e) {
                String message = "File access error: " + e.getMessage();
                throw new AlgorithmExecutionException(message, (Throwable)e);
            }
        }

        private Data[] createOutData(File inData) {
            Data[] dm = new Data[]{new BasicData((Object)inData, "file:text/nwb")};
            dm[0].getMetadata().put("Label", "NWB file: " + this.inNWBFileName);
            dm[0].getMetadata().put("Type", "Network");
            return dm;
        }
    }
}

