/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.nwb.writer;

import edu.iu.nwb.converter.nwb.common.ValidateNWBFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class NWBFileHandler
implements AlgorithmFactory {
    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new NWBFileHandlerAlgorithm(data, parameters, context);
    }

    public class NWBFileHandlerAlgorithm
    implements Algorithm {
        private Object inData;
        private String format;

        public NWBFileHandlerAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
            this.inData = data[0].getData();
            this.format = data[0].getFormat();
        }

        public Data[] execute() throws AlgorithmExecutionException {
            if (this.inData instanceof File) {
                if ("file:text/nwb".equals(this.format)) {
                    ValidateNWBFile validator = new ValidateNWBFile();
                    try {
                        validator.validateNWBFormat((File)this.inData);
                        if (validator.getValidationResult()) {
                            return new Data[]{new BasicData(this.inData, "file-ext:nwb")};
                        }
                        throw new AlgorithmExecutionException("This file does not seem to comply with the NWB format specification. Forwarding anyways.\nPlease notify the developers of the algorithm you are using or the NWB team.");
                    }
                    catch (FileNotFoundException e) {
                        String message = "Couldn't find NWB file to validate: " + e.getMessage();
                        throw new AlgorithmExecutionException(message, (Throwable)e);
                    }
                    catch (IOException e) {
                        String message = "File access error: " + e.getMessage();
                        throw new AlgorithmExecutionException(message, (Throwable)e);
                    }
                }
                String message = "Error: Expected file:text/nwb, but the input format is " + this.format;
                throw new AlgorithmExecutionException(message);
            }
            String message = "Expect a File, but the input data is " + this.inData.getClass().getName();
            throw new AlgorithmExecutionException(message);
        }
    }
}

