/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.nwbgraphml;

import edu.iu.nwb.converter.nwbgraphml.Attribute;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileUtilities;

public class GraphMLToNWBbyStax
implements Algorithm {
    private File inGraphMLFile;

    public GraphMLToNWBbyStax(Data[] data, Dictionary parameters, CIShellContext context) {
        this.inGraphMLFile = (File)data[0].getData();
    }

    public Data[] execute() throws AlgorithmExecutionException {
        File outNWBFile = this.createOutNWBFile(this.inGraphMLFile);
        return new Data[]{new BasicData((Object)outNWBFile, "file:text/nwb")};
    }

    private File createOutNWBFile(File inGraphMLFile) throws AlgorithmExecutionException {
        File outData = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlReader = null;
        try {
            try {
                xmlReader = inputFactory.createXMLStreamReader(new FileInputStream(inGraphMLFile));
            }
            catch (XMLStreamException e) {
                String message = "Error parsing GraphML file: " + e.getMessage();
                throw new AlgorithmExecutionException(message, (Throwable)e);
            }
            catch (FileNotFoundException e) {
                String message = "Error: Couldn't find GraphML file: " + e.getMessage();
                throw new AlgorithmExecutionException(message, (Throwable)e);
            }
            try {
                outData = this.convert(xmlReader);
            }
            catch (XMLStreamException e) {
                String message = "Error parsing GraphML file: " + e.getMessage();
                throw new AlgorithmExecutionException(message, (Throwable)e);
            }
            catch (IOException e) {
                String message = "File access error: " + e.getMessage();
                throw new AlgorithmExecutionException(message, (Throwable)e);
            }
        }
        finally {
            if (xmlReader != null) {
                try {
                    xmlReader.close();
                }
                catch (XMLStreamException e) {
                    String message = "Error: Unable to close XML Stream: " + e.getMessage();
                    throw new AlgorithmExecutionException(message, (Throwable)e);
                }
            }
        }
        return outData;
    }

    protected File convert(XMLStreamReader xmlReader) throws XMLStreamException, IOException {
        boolean directed = false;
        int nodeCount = 0;
        int directedEdgeCount = 0;
        int undirectedEdgeCount = 0;
        String labelKey = null;
        Hashtable<String, Integer> nodeIds = new Hashtable<String, Integer>();
        ArrayList<Attribute> nodeAttributes = new ArrayList<Attribute>();
        ArrayList<Attribute> edgeAttributes = new ArrayList<Attribute>();
        File nodeFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"NWB-node-", (String)"nwb");
        BufferedWriter nodeWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(nodeFile), "UTF-8"));
        File undirectedEdgeFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"NWB-undirected-", (String)"nwb");
        BufferedWriter undirectedEdgeWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(undirectedEdgeFile), "UTF-8"));
        File directedEdgeFile = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"NWB-directed-", (String)"nwb");
        BufferedWriter directedEdgeWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(directedEdgeFile), "UTF-8"));
        boolean wroteNodeHeader = false;
        boolean wroteEdgeHeader = false;
        while (xmlReader.hasNext()) {
            int eventType = xmlReader.next();
            if (eventType != 1) continue;
            if (xmlReader.getLocalName().equals("graph") && xmlReader.getAttributeCount() > 0 && "directed".equals(xmlReader.getAttributeValue(null, "edgedefault"))) {
                directed = true;
            }
            if (xmlReader.getLocalName().equals("node") && xmlReader.getAttributeCount() > 0) {
                nodeIds.put(xmlReader.getAttributeValue(null, "id"), new Integer(++nodeCount));
                if (nodeCount == 1) {
                    nodeWriter.write(this.createNodeHeader(nodeAttributes));
                    wroteNodeHeader = true;
                }
                nodeWriter.write(this.createNode(nodeCount, labelKey, this.extractAttributes(xmlReader, "node"), nodeAttributes));
            }
            if (xmlReader.getLocalName().equals("edge") && xmlReader.getAttributeCount() > 0) {
                boolean isDirected = this.isDirectedEdge(directed, xmlReader);
                Integer source = (Integer)nodeIds.get(xmlReader.getAttributeValue(null, "source"));
                Integer target = (Integer)nodeIds.get(xmlReader.getAttributeValue(null, "target"));
                Map attributeValues = this.extractAttributes(xmlReader, "edge");
                if (isDirected) {
                    if (++directedEdgeCount == 1) {
                        directedEdgeWriter.write(this.createDirectedEdgeHeader(edgeAttributes));
                        wroteEdgeHeader = true;
                    }
                    directedEdgeWriter.write(this.createEdge(source, target, attributeValues, edgeAttributes));
                } else {
                    if (++undirectedEdgeCount == 1) {
                        undirectedEdgeWriter.write(this.createUndirectedEdgeHeader(edgeAttributes));
                        wroteEdgeHeader = true;
                    }
                    undirectedEdgeWriter.write(this.createEdge(source, target, attributeValues, edgeAttributes));
                }
            }
            if (!xmlReader.getLocalName().equals("key") || xmlReader.getAttributeCount() <= 0) continue;
            Attribute attribute = this.readAttribute(xmlReader);
            if (!attribute.isReservedForNode() && attribute.isForNode()) {
                nodeAttributes.add(attribute);
            }
            if (!attribute.isReservedForEdge() && attribute.isForEdge()) {
                edgeAttributes.add(attribute);
            }
            if (!attribute.isForNode() || !attribute.isForLabel()) continue;
            labelKey = attribute.getId();
        }
        if (!wroteNodeHeader) {
            nodeWriter.write(this.createNodeHeader(nodeAttributes));
        }
        if (!wroteEdgeHeader) {
            undirectedEdgeWriter.write(this.createUndirectedEdgeHeader(edgeAttributes));
        }
        xmlReader.close();
        directedEdgeWriter.close();
        undirectedEdgeWriter.close();
        nodeWriter.close();
        File output = this.mergeFiles(nodeFile, undirectedEdgeFile, directedEdgeFile);
        directedEdgeFile.delete();
        undirectedEdgeFile.delete();
        return output;
    }

    protected File mergeFiles(File nodeFile, File undirectedEdgeFile, File directedEdgeFile) throws IOException {
        int c;
        FileOutputStream nodeStream = new FileOutputStream(nodeFile, true);
        SequenceInputStream edgeStream = new SequenceInputStream(new FileInputStream(undirectedEdgeFile), new FileInputStream(directedEdgeFile));
        while ((c = edgeStream.read()) != -1) {
            nodeStream.write(c);
        }
        return nodeFile;
    }

    protected String createNode(int id, String labelKey, Map attributeValues, List nodeAttributes) throws XMLStreamException {
        return id + "\t" + this.nodeAttributes(id, labelKey, attributeValues, nodeAttributes) + "\n";
    }

    protected String createUndirectedEdgeHeader(List edgeAttributes) {
        return "*UndirectedEdges\nsource*int target*int" + this.attributesHeader(edgeAttributes) + "\n";
    }

    protected String createDirectedEdgeHeader(List edgeAttributes) {
        return "*DirectedEdges\nsource*int target*int" + this.attributesHeader(edgeAttributes) + "\n";
    }

    protected String createEdge(int source, int target, Map attributeValues, List edgeAttributes) throws XMLStreamException {
        return source + "\t" + target + "\t" + this.edgeAttributes(attributeValues, edgeAttributes) + "\n";
    }

    protected Attribute readAttribute(XMLStreamReader xmlReader) throws XMLStreamException {
        Attribute attribute = new Attribute();
        attribute.setDomain(xmlReader.getAttributeValue(null, "for"));
        attribute.setId(xmlReader.getAttributeValue(null, "id"));
        attribute.setName(xmlReader.getAttributeValue(null, "attr.name"));
        attribute.setType(xmlReader.getAttributeValue(null, "attr.type"));
        while (xmlReader.hasNext()) {
            int eventType = xmlReader.next();
            if (eventType == 1) {
                if (!xmlReader.getLocalName().equals("default")) continue;
                attribute.setDefault(this.getElementText(xmlReader));
                continue;
            }
            if (eventType == 2) break;
        }
        return attribute;
    }

    public boolean isDirectedEdge(boolean defaultValue, XMLStreamReader xmlReader) {
        String attributeValue = xmlReader.getAttributeValue(null, "directed");
        if (defaultValue) {
            return !"false".equals(attributeValue);
        }
        return "true".equals(attributeValue);
    }

    public String createNodeHeader(List nodeAttributes) {
        return "*Nodes\nid*int label*string " + this.attributesHeader(nodeAttributes) + "\n";
    }

    public String attributesHeader(List attributesList) {
        StringBuffer header = new StringBuffer();
        for (Attribute attribute : attributesList) {
            header.append(" ");
            header.append(attribute.getName());
            header.append("*");
            header.append(attribute.getType());
        }
        return header.toString();
    }

    protected String nodeAttributes(int id, String labelKey, Map attributeValues, List nodeAttributes) throws XMLStreamException {
        String label = "" + id;
        if (labelKey != null && attributeValues.containsKey(labelKey)) {
            label = this.formatString((String)attributeValues.get(labelKey));
        }
        String value = this.attributesString(nodeAttributes, attributeValues);
        return "\"" + label + "\"" + value.toString();
    }

    protected String formatString(String string) {
        return string.replaceAll("\"", "");
    }

    protected Map extractAttributes(XMLStreamReader xmlReader, String endElement) throws XMLStreamException {
        Hashtable<String, String> attributeValues = new Hashtable<String, String>();
        while (xmlReader.hasNext()) {
            int eventType = xmlReader.next();
            if (eventType == 1) {
                if (!xmlReader.getLocalName().equals("data")) continue;
                attributeValues.put(xmlReader.getAttributeValue(null, "key"), this.getElementText(xmlReader));
                continue;
            }
            if (eventType == 2 && xmlReader.getLocalName().equals(endElement)) break;
        }
        return attributeValues;
    }

    protected String edgeAttributes(Map attributeValues, List edgeAttributes) throws XMLStreamException {
        return this.attributesString(edgeAttributes, attributeValues);
    }

    protected String attributesString(List attributeTypes, Map attributeValues) {
        StringBuffer value = new StringBuffer();
        for (Attribute attribute : attributeTypes) {
            String attributeValue;
            value.append(' ');
            if (attributeValues.containsKey(attribute.getId())) {
                attributeValue = (String)attributeValues.get(attribute.getId());
                if (attribute.isString()) {
                    value.append('\"');
                    value.append(this.formatString(attributeValue));
                    value.append('\"');
                    continue;
                }
                if ("null".equals(attributeValue)) {
                    value.append('*');
                    continue;
                }
                value.append(attributeValue);
                continue;
            }
            if (attribute.hasDefault()) {
                attributeValue = attribute.getDefault();
                if (attribute.isString()) {
                    value.append('\"');
                    value.append(this.formatString(attributeValue));
                    value.append('\"');
                    continue;
                }
                if ("null".equals(attributeValue)) {
                    value.append('*');
                    continue;
                }
                value.append(attributeValue);
                continue;
            }
            value.append('*');
        }
        return value.toString();
    }

    protected String getElementText(XMLStreamReader xmlReader) throws XMLStreamException {
        StringBuffer value = new StringBuffer();
        while (xmlReader.hasNext()) {
            int eventType = xmlReader.next();
            if (eventType == 4) {
                value.append(xmlReader.getText());
                continue;
            }
            if (eventType == 2) break;
        }
        return value.toString();
    }
}

