/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.nwbgraphml;

import edu.iu.nwb.converter.nwb.common.NWBAttribute;
import edu.iu.nwb.converter.nwb.common.ValidateNWBFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.FileUtilities;
import org.cishell.utilities.UnicodeReader;
import org.osgi.service.log.LogService;

public class NWBToGraphMLbyStax
implements Algorithm {
    public static final String GRAPHML_MIME_TYPE = "file:text/graphml+xml";
    public static final String EDGEDEFAULT_ATTRIBUTE_KEY = "edgedefault";
    public static final String GRAPH_ELEMENT = "graph";
    public static final String NODE_ELEMENT = "node";
    public static final String KEY_ATTRIBUTE_KEY = "key";
    public static final String DATA_ELEMENT = "data";
    public static final String EDGE_ELEMENT = "edge";
    public static final String ID_ATTRIBUTE_KEY = "id";
    public static final String TARGET_ATTRIBUTE_KEY = "target";
    public static final String SOURCE_ATTRIBUTE_KEY = "source";
    public static final String DOUBLE_TYPE_TOKEN = "double";
    public static final String XML_FILE_EXTENSION = "xml";
    public static final String SLIS_SOFTWARE_URL = "http://nwb.cns.iu.edu/doc.html";
    private File inNWBFile;
    private LogService logger;

    public NWBToGraphMLbyStax(File inNWBFile, LogService logger) {
        this.inNWBFile = inNWBFile;
        this.logger = logger;
    }

    public Data[] execute() throws AlgorithmExecutionException {
        try {
            ValidateNWBFile validator = new ValidateNWBFile();
            validator.validateNWBFormat(this.inNWBFile);
            if (validator.getValidationResult()) {
                File outGraphMLFile = this.convertNWBToGraphMLbyStax(this.inNWBFile, validator);
                return this.createOutData(outGraphMLFile);
            }
            String format = "Error: Unable to validate NWB file. %n %s%nPlease review the latest NWB Format Specification at %n%s, and update your file.";
            String exceptionMessage = String.format(format, validator.getErrorMessages(), SLIS_SOFTWARE_URL);
            throw new AlgorithmExecutionException(exceptionMessage);
        }
        catch (FileNotFoundException e) {
            String exceptionMessage = String.format("Couldn't find NWB file to validate: %s", e.getMessage());
            throw new AlgorithmExecutionException(exceptionMessage, (Throwable)e);
        }
        catch (IOException e) {
            String exceptionMessage = String.format("File access error: %s", e.getMessage());
            throw new AlgorithmExecutionException(exceptionMessage, (Throwable)e);
        }
    }

    private Data[] createOutData(File outGraphMLFile) {
        Data[] outData = new Data[]{new BasicData((Object)outGraphMLFile, GRAPHML_MIME_TYPE)};
        return outData;
    }

    private File convertNWBToGraphMLbyStax(File nwbFile, ValidateNWBFile validator) throws AlgorithmExecutionException {
        try {
            File graphml = FileUtilities.createTemporaryFileInDefaultTemporaryDirectory((String)"GraphML-", (String)XML_FILE_EXTENSION);
            BufferedReader reader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(nwbFile)));
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xmlWriter = xmlOutputFactory.createXMLStreamWriter(new FileOutputStream(graphml), "utf-8");
            this.writeGraphMLHeader(xmlWriter);
            this.writeAttributes(xmlWriter, validator);
            this.printGraph(xmlWriter, validator, reader);
            try {
                xmlWriter.writeEndElement();
                xmlWriter.writeEndElement();
            }
            catch (XMLStreamException e) {
                this.logger.log(2, e.getMessage(), (Throwable)e);
            }
            reader.close();
            xmlWriter.flush();
            xmlWriter.close();
            return graphml;
        }
        catch (UnsupportedEncodingException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private void writeGraphMLHeader(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartDocument("UTF-8", "1.0");
        xmlWriter.writeComment("This file is generated by XMLStreamWriter");
        xmlWriter.writeStartElement("graphml");
        xmlWriter.writeNamespace("", "http://graphml.graphdrawing.org/xmlns");
        xmlWriter.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
    }

    private void writeAttributes(XMLStreamWriter xtw, ValidateNWBFile validator) throws XMLStreamException, AlgorithmExecutionException {
        int i;
        String attrName;
        NWBAttribute attr;
        List array = validator.getNodeAttrList();
        int ii = 0;
        while (ii < array.size()) {
            attr = (NWBAttribute)array.get(ii);
            attrName = attr.getAttrName();
            if (!attrName.equalsIgnoreCase(ID_ATTRIBUTE_KEY)) {
                xtw.writeStartElement(KEY_ATTRIBUTE_KEY);
                xtw.writeAttribute(ID_ATTRIBUTE_KEY, attr.getAttrName().toLowerCase());
                xtw.writeAttribute("for", NODE_ELEMENT);
                xtw.writeAttribute("attr.name", attr.getAttrName());
                xtw.writeAttribute("attr.type", this.getGraphMLType(attr));
                xtw.writeEndElement();
            }
            ++ii;
        }
        if (validator.isDirectedGraph() && (!validator.isUndirectedGraph() || validator.getTotalNumOfUndirectedEdges() == 0)) {
            array = validator.getDirectedEdgeAttrList();
            i = 0;
            while (i < array.size()) {
                attr = (NWBAttribute)array.get(i);
                attrName = attr.getAttrName();
                if (!(attrName.equalsIgnoreCase(SOURCE_ATTRIBUTE_KEY) || attrName.equalsIgnoreCase(TARGET_ATTRIBUTE_KEY) || attrName.equalsIgnoreCase(ID_ATTRIBUTE_KEY))) {
                    xtw.writeStartElement(KEY_ATTRIBUTE_KEY);
                    xtw.writeAttribute(ID_ATTRIBUTE_KEY, attr.getAttrName().toLowerCase());
                    xtw.writeAttribute("for", EDGE_ELEMENT);
                    xtw.writeAttribute("attr.name", attr.getAttrName());
                    xtw.writeAttribute("attr.type", this.getGraphMLType(attr));
                    xtw.writeEndElement();
                }
                ++i;
            }
            xtw.writeStartElement(GRAPH_ELEMENT);
            xtw.writeAttribute(EDGEDEFAULT_ATTRIBUTE_KEY, "directed");
        } else if ((!validator.isDirectedGraph() || validator.getTotalNumOfDirectedEdges() == 0) && validator.isUndirectedGraph()) {
            array = validator.getUndirectedEdgeAttrList();
            i = 0;
            while (i < array.size()) {
                attr = (NWBAttribute)array.get(i);
                attrName = attr.getAttrName();
                if (!(attrName.equalsIgnoreCase(SOURCE_ATTRIBUTE_KEY) || attrName.equalsIgnoreCase(TARGET_ATTRIBUTE_KEY) || attrName.equalsIgnoreCase(ID_ATTRIBUTE_KEY))) {
                    xtw.writeStartElement(KEY_ATTRIBUTE_KEY);
                    xtw.writeAttribute(ID_ATTRIBUTE_KEY, attr.getAttrName().toLowerCase());
                    xtw.writeAttribute("for", EDGE_ELEMENT);
                    xtw.writeAttribute("attr.name", attr.getAttrName());
                    xtw.writeAttribute("attr.type", this.getGraphMLType(attr));
                    xtw.writeEndElement();
                }
                ++i;
            }
            xtw.writeStartElement(GRAPH_ELEMENT);
            xtw.writeAttribute(EDGEDEFAULT_ATTRIBUTE_KEY, "undirected");
        } else {
            if (validator.isDirectedGraph() && validator.isUndirectedGraph()) {
                throw new AlgorithmExecutionException("Unable to convert hybrid NWB graph file to GraphML.");
            }
            xtw.writeStartElement(GRAPH_ELEMENT);
            xtw.writeAttribute(EDGEDEFAULT_ATTRIBUTE_KEY, "undirected");
        }
    }

    private void printGraph(XMLStreamWriter xtw, ValidateNWBFile validator, BufferedReader reader) throws XMLStreamException, IOException {
        boolean inNodesSection = false;
        boolean inDirectededgesSection = false;
        boolean inUndirectededgesSection = false;
        String line = reader.readLine();
        int edgeID = 0;
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
                line = reader.readLine();
                continue;
            }
            if (line.startsWith("*Nodes")) {
                inNodesSection = true;
                inDirectededgesSection = false;
                inUndirectededgesSection = false;
                line = reader.readLine();
                continue;
            }
            if (line.startsWith("*DirectedEdges")) {
                inDirectededgesSection = true;
                inNodesSection = false;
                inUndirectededgesSection = false;
                line = reader.readLine();
                continue;
            }
            if (line.startsWith("*UndirectedEdges")) {
                inUndirectededgesSection = true;
                inNodesSection = false;
                inDirectededgesSection = false;
                line = reader.readLine();
                continue;
            }
            if (inNodesSection) {
                if (line.startsWith(ID_ATTRIBUTE_KEY) || line.startsWith("#id") || line.startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                StringTokenizer st = new StringTokenizer(line);
                String[] columns = validator.processTokens(st);
                List nodeAttrList = validator.getNodeAttrList();
                xtw.writeStartElement(NODE_ELEMENT);
                xtw.writeAttribute(ID_ATTRIBUTE_KEY, "n" + columns[0]);
                int i = 1;
                while (i < nodeAttrList.size()) {
                    NWBAttribute attr = (NWBAttribute)nodeAttrList.get(i);
                    String value = columns[i];
                    if (attr.getDataType().equalsIgnoreCase("string")) {
                        if (value.startsWith("\"")) {
                            value = value.substring(1);
                        }
                        if (value.endsWith("\"")) {
                            value = value.substring(0, value.length() - 1);
                        }
                    }
                    if (!value.equalsIgnoreCase("*")) {
                        xtw.writeStartElement(DATA_ELEMENT);
                        xtw.writeAttribute(KEY_ATTRIBUTE_KEY, attr.getAttrName().toLowerCase());
                        xtw.writeCharacters(value);
                        xtw.writeEndElement();
                    }
                    ++i;
                }
                xtw.writeEndElement();
            }
            if (inDirectededgesSection || inUndirectededgesSection) {
                String attrName;
                NWBAttribute attr;
                int i;
                if (line.startsWith(SOURCE_ATTRIBUTE_KEY) || line.startsWith("#source") || line.startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                List edgeAttrList = new ArrayList();
                StringTokenizer st = new StringTokenizer(line);
                String[] columns = validator.processTokens(st);
                if (inDirectededgesSection) {
                    edgeAttrList = validator.getDirectedEdgeAttrList();
                } else if (inUndirectededgesSection) {
                    edgeAttrList = validator.getUndirectedEdgeAttrList();
                }
                ++edgeID;
                int idColumnNumber = this.findAttr(ID_ATTRIBUTE_KEY, edgeAttrList);
                int sourceColumnNumber = this.findAttr(SOURCE_ATTRIBUTE_KEY, edgeAttrList);
                int targetColumnNumber = this.findAttr(TARGET_ATTRIBUTE_KEY, edgeAttrList);
                if (idColumnNumber == -1) {
                    if (edgeAttrList.size() > 2) {
                        xtw.writeStartElement(EDGE_ELEMENT);
                        xtw.writeAttribute(ID_ATTRIBUTE_KEY, "e" + new Integer(edgeID).toString());
                        xtw.writeAttribute(SOURCE_ATTRIBUTE_KEY, "n" + columns[sourceColumnNumber]);
                        xtw.writeAttribute(TARGET_ATTRIBUTE_KEY, "n" + columns[targetColumnNumber]);
                        i = 0;
                        while (i < edgeAttrList.size()) {
                            attr = (NWBAttribute)edgeAttrList.get(i);
                            attrName = attr.getAttrName();
                            if (!(attrName.equalsIgnoreCase(SOURCE_ATTRIBUTE_KEY) || attrName.equalsIgnoreCase(TARGET_ATTRIBUTE_KEY) || attrName.equalsIgnoreCase(ID_ATTRIBUTE_KEY))) {
                                String value = columns[i];
                                if (attr.getDataType().equalsIgnoreCase("string")) {
                                    if (value.startsWith("\"")) {
                                        value = value.substring(1);
                                    }
                                    if (value.endsWith("\"")) {
                                        value = value.substring(0, value.length() - 1);
                                    }
                                }
                                if (!value.equalsIgnoreCase("*")) {
                                    xtw.writeStartElement(DATA_ELEMENT);
                                    xtw.writeAttribute(KEY_ATTRIBUTE_KEY, attr.getAttrName().toLowerCase());
                                    xtw.writeCharacters(value);
                                    xtw.writeEndElement();
                                }
                            }
                            ++i;
                        }
                        xtw.writeEndElement();
                    } else {
                        xtw.writeStartElement(EDGE_ELEMENT);
                        xtw.writeAttribute(ID_ATTRIBUTE_KEY, "e" + new Integer(edgeID).toString());
                        xtw.writeAttribute(SOURCE_ATTRIBUTE_KEY, "n" + columns[sourceColumnNumber]);
                        xtw.writeAttribute(TARGET_ATTRIBUTE_KEY, "n" + columns[targetColumnNumber]);
                        xtw.writeEndElement();
                    }
                } else if (edgeAttrList.size() > 3) {
                    xtw.writeStartElement(EDGE_ELEMENT);
                    xtw.writeAttribute(ID_ATTRIBUTE_KEY, "e" + columns[idColumnNumber]);
                    xtw.writeAttribute(SOURCE_ATTRIBUTE_KEY, "n" + columns[sourceColumnNumber]);
                    xtw.writeAttribute(TARGET_ATTRIBUTE_KEY, "n" + columns[targetColumnNumber]);
                    i = 0;
                    while (i < edgeAttrList.size()) {
                        attr = (NWBAttribute)edgeAttrList.get(i);
                        attrName = attr.getAttrName();
                        if (!(attrName.equalsIgnoreCase(SOURCE_ATTRIBUTE_KEY) || attrName.equalsIgnoreCase(TARGET_ATTRIBUTE_KEY) || attrName.equalsIgnoreCase(ID_ATTRIBUTE_KEY) || columns[i].equalsIgnoreCase("*"))) {
                            xtw.writeStartElement(DATA_ELEMENT);
                            xtw.writeAttribute(KEY_ATTRIBUTE_KEY, attr.getAttrName().toLowerCase());
                            xtw.writeCharacters(columns[i]);
                            xtw.writeEndElement();
                        }
                        ++i;
                    }
                    xtw.writeEndElement();
                } else {
                    xtw.writeStartElement(EDGE_ELEMENT);
                    xtw.writeAttribute(ID_ATTRIBUTE_KEY, "e" + columns[idColumnNumber]);
                    xtw.writeAttribute(SOURCE_ATTRIBUTE_KEY, "n" + columns[sourceColumnNumber]);
                    xtw.writeAttribute(TARGET_ATTRIBUTE_KEY, "n" + columns[targetColumnNumber]);
                    xtw.writeEndElement();
                }
            }
            line = reader.readLine();
        }
    }

    private int findAttr(String attrName, List attrList) {
        int ii = 0;
        while (ii < attrList.size()) {
            NWBAttribute attr = (NWBAttribute)attrList.get(ii);
            if (attr.getAttrName().equalsIgnoreCase(attrName)) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    protected static String escape(String s) {
        String val = s.replaceAll("&amp;|&", "&amp;");
        val = val.replaceAll("&lt;|<", "&lt;");
        val = val.replaceAll("&gt;|>", "&gt;");
        val = val.replaceAll("&quot;|\"", "&quot;");
        val = val.replaceAll("&apos;|'", "&apos;");
        return val;
    }

    private String getGraphMLType(NWBAttribute attr) {
        String type = attr.getDataType();
        if ("real".equals(type)) {
            type = DOUBLE_TYPE_TOKEN;
        } else if ("float".equals(type)) {
            type = DOUBLE_TYPE_TOKEN;
        }
        return type;
    }
}

