/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.pajeknet.common;

import edu.iu.nwb.converter.pajeknet.common.NETAttribute;
import edu.iu.nwb.converter.pajeknet.common.NETFileFormatException;
import edu.iu.nwb.converter.pajeknet.common.NETFileFunctions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class NETArcsnEdges {
    private static Map Attributes = new LinkedHashMap();
    private Map Numeric_Parameters;
    private Map String_Parameters;
    private int source;
    private int target;
    private String comment = null;
    private int unknowns = 0;
    private boolean valid = false;

    public NETArcsnEdges() {
        this.Numeric_Parameters = new ConcurrentHashMap();
        this.String_Parameters = new ConcurrentHashMap();
    }

    public NETArcsnEdges(String s) throws NETFileFormatException {
        String[] properties = NETFileFunctions.processTokens(s);
        this.Numeric_Parameters = new ConcurrentHashMap();
        this.String_Parameters = new ConcurrentHashMap();
        this.valid = this.testArcsnEdges(properties);
    }

    public boolean testArcsnEdges(String[] strings) throws NETFileFormatException {
        String s;
        boolean value = true;
        ConcurrentLinkedQueue<String> stringQueue = new ConcurrentLinkedQueue<String>();
        int ii = 0;
        while (ii < strings.length) {
            s = strings[ii];
            stringQueue.add(s);
            ++ii;
        }
        if (((String)stringQueue.peek()).startsWith("%")) {
            this.comment = "";
            ii = 0;
            while (ii < strings.length) {
                s = strings[ii];
                this.comment = String.valueOf(this.comment) + s;
                ++ii;
            }
            return true;
        }
        this.testSourceTargetWeight(stringQueue);
        if (!stringQueue.isEmpty()) {
            this.testParameters(stringQueue);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testSourceTargetWeight(Queue qs) throws NETFileFormatException {
        boolean value = true;
        try {
            if (qs.size() < 2) {
                value = false;
                throw new NETFileFormatException("Arcs and edges must contain both source and target values");
            }
            int i = 0;
            while (true) {
                if (i >= 3) {
                    return value;
                }
                String s = (String)qs.peek();
                value = true;
                switch (i) {
                    case 0: {
                        this.setSource(s);
                        break;
                    }
                    case 1: {
                        this.setTarget(s);
                        break;
                    }
                    case 2: {
                        try {
                            this.setWeight(s);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return value;
                        }
                    }
                    default: {
                        return true;
                    }
                }
                qs.poll();
                ++i;
            }
        }
        catch (NullPointerException nullPointerException) {
            this.setWeight("1");
            return value;
        }
    }

    public boolean testParameters(Queue qs) {
        boolean value = false;
        while (!qs.isEmpty()) {
            String s;
            String s1 = (String)qs.poll();
            String s2 = (String)qs.peek();
            if (s1.equalsIgnoreCase("w")) {
                this.setWidth(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("c")) {
                if (NETFileFunctions.isAFloat(s2, "float") || NETFileFunctions.isAnInteger(s2, "int")) {
                    s = (String)qs.poll();
                    s = String.valueOf(s) + " " + qs.poll() + " ";
                    s = String.valueOf(s) + " " + qs.poll();
                    this.setColor(s);
                    continue;
                }
                this.setColor(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("p")) {
                this.setPattern(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("s")) {
                this.setSize(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("a")) {
                this.setArrowShape(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("ap")) {
                this.setArrowPosition(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("l")) {
                this.setLabel(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("lp")) {
                this.setLabelPosition(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("lr")) {
                this.setLabelRadius(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("lphi")) {
                this.setLabelPhi(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("lc")) {
                if (NETFileFunctions.isAFloat(s2, "float") || NETFileFunctions.isAnInteger(s2, "int")) {
                    s = (String)qs.poll();
                    s = String.valueOf(s) + " " + qs.poll() + " ";
                    s = String.valueOf(s) + " " + qs.poll();
                    this.setLabelColor(s);
                    continue;
                }
                this.setLabelColor(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("la")) {
                this.setLabelAngle(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("fos")) {
                this.setFontSize(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("font")) {
                this.setFont(s2);
                qs.poll();
                continue;
            }
            if (s1.startsWith("h") && NETFileFunctions.isAnInteger(s1.substring(1), "int")) {
                this.setHook(s1, s2);
                qs.poll();
                continue;
            }
            if (s1.startsWith("a") && NETFileFunctions.isAnInteger(s1.substring(1), "int")) {
                this.setAngle(s1, s2);
                qs.poll();
                continue;
            }
            if (s1.startsWith("k") && NETFileFunctions.isAnInteger(s1.substring(1), "int")) {
                this.setVelocity(s1, s2);
                qs.poll();
                continue;
            }
            if (s1.startsWith("%")) {
                qs.clear();
                break;
            }
            this.setUnknownAttribute(s1);
        }
        value = true;
        return value;
    }

    protected static void clearAttributes() {
        Attributes.clear();
    }

    public void setUnknownAttribute(String s) {
        if (s != null) {
            String name = "unknown" + this.unknowns;
            Attributes.put(name, "string");
            this.String_Parameters.put(name, s);
            ++this.unknowns;
        }
    }

    public void setSource(String s) throws NETFileFormatException {
        int i = NETFileFunctions.asAnInteger(s);
        Attributes.put("source", "int");
        if (i <= 0) {
            throw new NETFileFormatException("Source id must be greater than 0");
        }
        this.source = i;
    }

    public void setTarget(String s) throws NETFileFormatException {
        int i = NETFileFunctions.asAnInteger(s);
        Attributes.put("target", "int");
        if (i <= 0) {
            throw new NETFileFormatException("Target id must be greater than 0");
        }
        this.target = i;
    }

    public void setWeight(String s) {
        float f = NETFileFunctions.asAFloat(s);
        Attributes.put("weight", "float");
        this.Numeric_Parameters.put("weight", new Float(f));
    }

    private void setWidth(float f) {
        Attributes.put("w", "float");
        this.Numeric_Parameters.put("w", new Float(f));
    }

    public void setWidth(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setWidth(f);
    }

    public void setColor(String s) {
        if (s != null) {
            String[] number = s.split(" ");
            if (NETFileFunctions.isAFloat(number[0], "float") || NETFileFunctions.isAnInteger(number[0], "int")) {
                Attributes.put("c", "float");
                this.Numeric_Parameters.put("c", s);
            } else {
                Attributes.put("c", "string");
                this.String_Parameters.put("c", s);
            }
        }
    }

    public void setPattern(String s) {
        if (s != null) {
            Attributes.put("p", "string");
            this.String_Parameters.put("p", s);
        }
    }

    private void setSize(float f) {
        Attributes.put("s", "float");
        this.Numeric_Parameters.put("s", new Float(f));
    }

    public void setSize(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setSize(f);
    }

    public void setArrowShape(String s) {
        if (s != null) {
            Attributes.put("a", "string");
            this.String_Parameters.put("a", s);
        }
    }

    private void setArrowPosition(float f) {
        Attributes.put("ap", "float");
        this.Numeric_Parameters.put("ap", new Float(f));
    }

    public void setArrowPosition(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setArrowPosition(f);
    }

    public void setLabel(String s) {
        if (s != null) {
            Attributes.put("l", "string");
            this.String_Parameters.put("l", s);
        }
    }

    private void setLabelPosition(float f) {
        Attributes.put("lp", "string");
        this.Numeric_Parameters.put("lp", new Float(f));
    }

    public void setLabelPosition(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setLabelPosition(f);
    }

    private void setLabelRadius(float f) {
        Attributes.put("lr", "string");
        this.Numeric_Parameters.put("lr", new Float(f));
    }

    public void setLabelRadius(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setLabelRadius(f);
    }

    private void setLabelPhi(float f) {
        Attributes.put("lphi", "float");
        this.Numeric_Parameters.put("lphi", new Float(f));
    }

    public void setLabelPhi(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setLabelPhi(f);
    }

    public void setLabelColor(String s) {
        if (s != null) {
            String[] number = s.split(" ");
            if (NETFileFunctions.isAFloat(number[0], "float") || NETFileFunctions.isAnInteger(number[0], "int")) {
                Attributes.put("lc", "float");
                this.Numeric_Parameters.put("lc", s);
            } else {
                Attributes.put("lc", "string");
                this.String_Parameters.put("lc", s);
            }
        }
    }

    private void setLabelAngle(float f) {
        Attributes.put("la", "string");
        this.Numeric_Parameters.put("la", new Float(f));
    }

    public void setLabelAngle(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setLabelAngle(f);
    }

    private void setFontSize(float f) {
        Attributes.put("fos", "float");
        this.Numeric_Parameters.put("fos", new Float(f));
    }

    public void setFontSize(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setFontSize(f);
    }

    public void setFont(String s) {
        if (s != null) {
            Attributes.put("font", "string");
            this.String_Parameters.put("font", s);
        }
    }

    public void setHook(String s1, String s2) {
        Attributes.put(s1, "float");
        this.Numeric_Parameters.put(s1, new Float(NETFileFunctions.asAFloat(s2)));
    }

    public void setAngle(String s1, String s2) {
        Attributes.put(s1, "float");
        this.Numeric_Parameters.put(s1, new Float(NETFileFunctions.asAFloat(s2)));
    }

    public void setVelocity(String s1, String s2) {
        Attributes.put(s1, "float");
        this.Numeric_Parameters.put(s1, new Float(NETFileFunctions.asAFloat(s2)));
    }

    public Object getAttribute(String s) {
        String st = (String)Attributes.get(s);
        if (st == null) {
            return null;
        }
        if (s.equalsIgnoreCase("source")) {
            return new Integer(this.source);
        }
        if (s.equalsIgnoreCase("target")) {
            return new Integer(this.target);
        }
        if (st.equalsIgnoreCase("float")) {
            return this.Numeric_Parameters.get(s);
        }
        return this.String_Parameters.get(s);
    }

    public boolean isValid() {
        return this.valid;
    }

    public static List getArcsnEdgesAttributes() {
        ArrayList<NETAttribute> attributeList = new ArrayList<NETAttribute>();
        for (String s : Attributes.keySet()) {
            attributeList.add(new NETAttribute(s, (String)Attributes.get(s)));
        }
        return attributeList;
    }

    public String toString() {
        String output = "";
        for (String s : Attributes.keySet()) {
            output = String.valueOf(output) + s + ":" + this.getAttribute(s) + " ";
        }
        return output;
    }
}

