/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.pajeknet.common;

import edu.iu.nwb.converter.pajeknet.common.NETArcsnEdges;
import edu.iu.nwb.converter.pajeknet.common.NETFileFormatException;
import edu.iu.nwb.converter.pajeknet.common.NETVertex;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.StringTokenizer;
import org.cishell.utilities.UnicodeReader;

public class NETFileValidator {
    private boolean hasHeader_Vertices = false;
    private boolean hasHeader_Edges = false;
    private boolean hasHeader_Arcs = false;
    private boolean isFileGood = true;
    private boolean inVerticesSection = false;
    private boolean inEdgesSection = false;
    private boolean inArcsSection = false;
    private boolean hasTotalNumOfNodes = false;
    private boolean skipNodeList;
    private int totalNumOfNodes;
    private int currentLine;
    private StringBuffer errorMessages = new StringBuffer();
    private int numVertices;
    private int numArcs;
    private int numEdges;

    public void validateNETFormat(File fileHandler) throws FileNotFoundException, IOException {
        this.currentLine = 0;
        this.totalNumOfNodes = 0;
        this.numVertices = 0;
        this.numArcs = 0;
        this.numEdges = 0;
        BufferedReader reader = new BufferedReader((Reader)new UnicodeReader((InputStream)new FileInputStream(fileHandler)));
        this.processFile(reader);
    }

    public boolean isDirectedGraph() {
        return this.hasHeader_Arcs && this.numArcs > 0;
    }

    public boolean isUndirectedGraph() {
        return this.hasHeader_Edges && this.numEdges > 0;
    }

    public boolean getValidationResult() {
        return this.isFileGood;
    }

    public String getErrorMessages() {
        return this.errorMessages.toString();
    }

    public List getVertexAttrList() {
        return NETVertex.getVertexAttributes();
    }

    public List getEdgeAttrList() {
        return NETArcsnEdges.getArcsnEdgesAttributes();
    }

    public List getArcAttrList() {
        return NETArcsnEdges.getArcsnEdgesAttributes();
    }

    public int getTotalNumOfNodes() {
        return this.totalNumOfNodes;
    }

    public boolean getHasTotalNumOfNodes() {
        return this.hasTotalNumOfNodes;
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public int getNumArcs() {
        return this.numArcs;
    }

    public int getNumEdges() {
        return this.numEdges;
    }

    public boolean validateVertexHeader(String s) {
        if ((s = s.toLowerCase()).startsWith("*vertices")) {
            this.hasHeader_Vertices = true;
            this.inVerticesSection = true;
            this.inEdgesSection = false;
            this.inArcsSection = false;
            this.numVertices = 0;
            StringTokenizer st = new StringTokenizer(s);
            if (st.countTokens() > 1) {
                st.nextToken();
                this.totalNumOfNodes = new Integer(st.nextToken());
                this.hasTotalNumOfNodes = true;
            } else {
                this.hasTotalNumOfNodes = false;
            }
            return true;
        }
        return false;
    }

    public boolean validateArcHeader(String s) {
        if ((s = s.toLowerCase()).startsWith("*arcs")) {
            this.hasHeader_Arcs = true;
            this.inArcsSection = true;
            this.inVerticesSection = false;
            this.inEdgesSection = false;
            this.numArcs = 0;
            if (this.numVertices == 0) {
                this.skipNodeList = true;
            }
            return true;
        }
        return false;
    }

    public boolean validateEdgeHeader(String s) {
        if ((s = s.toLowerCase()).startsWith("*edges")) {
            this.hasHeader_Edges = true;
            this.inArcsSection = false;
            this.inVerticesSection = false;
            this.inEdgesSection = true;
            this.numEdges = 0;
            if (this.numVertices == 0) {
                this.skipNodeList = true;
            }
            return true;
        }
        return false;
    }

    public NETVertex processVertices(String s) {
        NETVertex nv = null;
        try {
            nv = new NETVertex(s);
        }
        catch (NETFileFormatException e) {
            this.isFileGood = false;
            this.errorMessages.append("*Wrong NET format at line " + this.currentLine + ".\n" + e.getMessage() + "\n\n");
        }
        return nv;
    }

    public NETArcsnEdges processArcsnEdges(String s) {
        NETArcsnEdges nae = null;
        try {
            nae = new NETArcsnEdges(s);
        }
        catch (NETFileFormatException e) {
            this.isFileGood = false;
            this.errorMessages.append("*Wrong NET format at line " + this.currentLine + ".\n" + e.toString() + "\n\n");
        }
        return nae;
    }

    public void processFile(BufferedReader reader) throws IOException {
        NETVertex.clearAttributes();
        NETArcsnEdges.clearAttributes();
        String line = reader.readLine();
        while (line != null && this.isFileGood) {
            ++this.currentLine;
            if ((line = line.trim()).startsWith("%") || line.length() < 1) {
                line = reader.readLine();
                continue;
            }
            if (this.validateVertexHeader(line)) {
                line = reader.readLine();
                continue;
            }
            if (this.validateArcHeader(line)) {
                line = reader.readLine();
                continue;
            }
            if (this.validateEdgeHeader(line)) {
                line = reader.readLine();
                continue;
            }
            if (this.inVerticesSection && this.isFileGood) {
                this.processVertices(line);
                ++this.numVertices;
                line = reader.readLine();
                continue;
            }
            if (this.inEdgesSection && this.isFileGood) {
                this.processArcsnEdges(line);
                ++this.numEdges;
                line = reader.readLine();
                continue;
            }
            if (this.inArcsSection && this.isFileGood) {
                this.processArcsnEdges(line);
                ++this.numArcs;
                line = reader.readLine();
                continue;
            }
            line = reader.readLine();
        }
        if (this.isFileGood) {
            this.checkFile();
        }
        if (this.hasTotalNumOfNodes && !this.skipNodeList && this.totalNumOfNodes != this.numVertices) {
            this.errorMessages.append("The stated total number of vertices (" + this.totalNumOfNodes + ") does not match the calculated number of vertices (" + this.numVertices + ")");
            this.isFileGood = false;
        }
        if (!this.hasTotalNumOfNodes) {
            this.totalNumOfNodes = this.numVertices;
        }
    }

    public void checkFile() {
        if (!this.hasHeader_Vertices) {
            this.isFileGood = false;
            this.errorMessages.append("*The file does not specify the Vertex header.\n\n");
        } else if (!this.hasTotalNumOfNodes && this.skipNodeList) {
            this.isFileGood = false;
            this.errorMessages.append("*The file does not specify the total number of vertices and does not list all vertices.\n\n");
        } else if (!this.hasHeader_Arcs && !this.hasHeader_Edges) {
            this.isFileGood = false;
            this.errorMessages.append("This file does not have the correct header to specify Arcs or Edges");
        }
    }
}

