/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.pajeknet.common;

import edu.iu.nwb.converter.pajeknet.common.NETAttribute;
import edu.iu.nwb.converter.pajeknet.common.NETFileFormatException;
import edu.iu.nwb.converter.pajeknet.common.NETFileFunctions;
import edu.iu.nwb.converter.pajeknet.common.NETFileShape;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class NETVertex {
    private static Map Attributes = new LinkedHashMap();
    private Map Numeric_Parameters;
    private Map String_Parameters;
    private int id;
    private String comment = null;
    private String label = null;
    private int unknowns = 0;
    private boolean valid = false;

    public NETVertex() {
        this.Numeric_Parameters = new ConcurrentHashMap();
        this.String_Parameters = new ConcurrentHashMap();
    }

    public NETVertex(String s) throws NETFileFormatException {
        String[] properties = NETFileFunctions.processTokens(s);
        this.Numeric_Parameters = new ConcurrentHashMap();
        this.String_Parameters = new ConcurrentHashMap();
        this.valid = this.testVertices(properties);
    }

    public boolean testVertices(String[] strings) throws NETFileFormatException {
        String s;
        boolean value = true;
        ConcurrentLinkedQueue<String> stringQueue = new ConcurrentLinkedQueue<String>();
        int ii = 0;
        while (ii < strings.length) {
            s = strings[ii];
            stringQueue.add(s);
            ++ii;
        }
        if (((String)stringQueue.peek()).startsWith("%")) {
            this.comment = "";
            ii = 0;
            while (ii < strings.length) {
                s = strings[ii];
                this.comment = String.valueOf(this.comment) + s;
                ++ii;
            }
            return true;
        }
        this.testVertexID(stringQueue);
        if (!stringQueue.isEmpty()) {
            this.testVertexPosition(stringQueue);
            this.testParameters(stringQueue);
        }
        return value;
    }

    public boolean testVertexID(Queue qs) throws NETFileFormatException {
        if (qs.size() < 2) {
            throw new NETFileFormatException("Vertices must have both ID and Label");
        }
        String s = (String)qs.poll();
        this.setID(s);
        s = (String)qs.poll();
        this.setLabel(s);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testVertexPosition(Queue qs) throws NETFileFormatException {
        boolean value = false;
        float f = 0.0f;
        int i = 0;
        try {
            while (true) {
                if (qs.isEmpty()) {
                    return false;
                }
                String s = (String)qs.peek();
                f = new Float(s).floatValue();
                value = true;
                switch (i) {
                    case 0: {
                        this.setPos("Xpos", f);
                        break;
                    }
                    case 1: {
                        this.setPos("Ypos", f);
                        break;
                    }
                    case 2: {
                        this.setPos("Zpos", f);
                        break;
                    }
                    default: {
                        return true;
                    }
                }
                ++i;
                qs.poll();
            }
        }
        catch (NumberFormatException numberFormatException) {
            return value;
        }
    }

    public boolean setVertexShape(String st) {
        this.setShape(st);
        return true;
    }

    public boolean testParameters(Queue qs) throws NETFileFormatException {
        boolean value = false;
        while (!qs.isEmpty()) {
            String s;
            String s1 = (String)qs.poll();
            if (NETFileFunctions.isInList(s1, NETFileShape.ATTRIBUTE_SHAPE_LIST)) {
                this.setShape(s1);
                continue;
            }
            String s2 = (String)qs.peek();
            if (s1.equalsIgnoreCase("x_fact")) {
                this.setXScaleFactor(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("y_fact")) {
                this.setYScaleFactor(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("s_size")) {
                this.setSize(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("phi")) {
                this.setPhi(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("r")) {
                this.setCornerRadius(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("q")) {
                this.setDiamondRatio(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("ic") || s1.equalsIgnoreCase("c")) {
                if (NETFileFunctions.isAFloat(s2, "float") || NETFileFunctions.isAnInteger(s2, "int")) {
                    s = (String)qs.poll();
                    s = String.valueOf(s) + " " + qs.poll() + " ";
                    s = String.valueOf(s) + " " + qs.poll();
                    this.setInternalColor(s);
                    continue;
                }
                this.setInternalColor(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("bc")) {
                if (NETFileFunctions.isAFloat(s2, "float") || NETFileFunctions.isAnInteger(s2, "int")) {
                    s = (String)qs.poll();
                    s = String.valueOf(s) + " " + qs.poll() + " ";
                    s = String.valueOf(s) + " " + qs.poll();
                    this.setBorderColor(s);
                    continue;
                }
                this.setBorderColor(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("bw")) {
                this.setBorderWidth(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("lc")) {
                if (NETFileFunctions.isAFloat(s2, "float") || NETFileFunctions.isAnInteger(s2, "int")) {
                    s = (String)qs.poll();
                    s = String.valueOf(s) + " " + qs.poll() + " ";
                    s = String.valueOf(s) + " " + qs.poll();
                    this.setLabelColor(s);
                    continue;
                }
                this.setLabelColor(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("la")) {
                this.setLabelAngle(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("font")) {
                this.setFont(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("lphi")) {
                this.setLabelPhi(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("fos")) {
                this.setFontSize(s2);
                qs.poll();
                continue;
            }
            if (s1.equalsIgnoreCase("lr")) {
                this.setLabelRadius(s2);
                qs.poll();
                continue;
            }
            if (s1.startsWith("%")) {
                qs.clear();
                break;
            }
            if (s1.startsWith("sh")) {
                this.setVertexShape(s2);
                qs.poll();
                continue;
            }
            this.setUnknownAttribute(s1);
        }
        value = true;
        return value;
    }

    private void setID(int i) {
        Attributes.put("id", "int");
        this.id = i;
    }

    public void setID(String s) throws NETFileFormatException {
        int i = NETFileFunctions.asAnInteger(s);
        if (i < 1) {
            throw new NETFileFormatException("Vertex ID must be greater than or equal to 1.");
        }
        this.setID(i);
    }

    public void setLabel(String s) throws NETFileFormatException {
        if (s == null || s.equals("")) {
            throw new NETFileFormatException("Each vertex must have a label.");
        }
        Attributes.put("label", "string");
        this.label = s;
    }

    private void setUnknownAttribute(String s) {
        if (s != null) {
            String name = "unknown" + this.unknowns;
            Attributes.put(name, "string");
            this.String_Parameters.put(name, s);
            ++this.unknowns;
        }
    }

    private void setXpos(float f) {
        Attributes.put("xpos", "float");
        this.Numeric_Parameters.put("xpos", new Float(f));
    }

    private void setYpos(float f) {
        Attributes.put("ypos", "float");
        this.Numeric_Parameters.put("ypos", new Float(f));
    }

    private void setZpos(float f) {
        Attributes.put("zpos", "float");
        this.Numeric_Parameters.put("zpos", new Float(f));
    }

    public void setPos(String s, float f) throws NETFileFormatException {
        switch (s.charAt(0)) {
            case 'X': 
            case 'x': {
                this.setXpos(f);
                break;
            }
            case 'Y': 
            case 'y': {
                this.setYpos(f);
                break;
            }
            case 'Z': 
            case 'z': {
                this.setZpos(f);
                break;
            }
            default: {
                throw new NETFileFormatException("Unknown positional data");
            }
        }
    }

    public void setShape(String s) {
        if (s != null) {
            Attributes.put("shape", "string");
            this.String_Parameters.put("shape", s);
        }
    }

    private void setPhi(float f) {
        Attributes.put("phi", "float");
        this.Numeric_Parameters.put("phi", new Float(f));
    }

    public void setPhi(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setPhi(f);
    }

    private void setSize(float f) {
        Attributes.put("s_size", "float");
        this.Numeric_Parameters.put("s_size", new Float(f));
    }

    public void setSize(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setSize(f);
    }

    public void setFont(String s) {
        if (s != null) {
            Attributes.put("font", "string");
            this.String_Parameters.put("font", s);
        }
    }

    public void setBorderColor(String s) {
        if (s != null) {
            String[] number = s.split(" ");
            if (NETFileFunctions.isAFloat(number[0], "float") || NETFileFunctions.isAnInteger(number[0], "int")) {
                Attributes.put("bc", "float");
                this.Numeric_Parameters.put("bc", s);
            } else {
                Attributes.put("bc", "string");
                this.String_Parameters.put("bc", s);
            }
        }
    }

    private void setBorderWidth(float f) {
        Attributes.put("bw", "float");
        this.Numeric_Parameters.put("bw", new Float(f));
    }

    public void setBorderWidth(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setBorderWidth(f);
    }

    private void setInternalColor(String s) {
        if (s != null) {
            String[] number = s.split(" ");
            if (NETFileFunctions.isAFloat(number[0], "float") || NETFileFunctions.isAnInteger(number[0], "int")) {
                Attributes.put("ic", "float");
                this.Numeric_Parameters.put("ic", s);
            } else {
                Attributes.put("ic", "string");
                this.String_Parameters.put("ic", s);
            }
        }
    }

    private void setFontSize(float f) {
        Attributes.put("fos", "float");
        this.Numeric_Parameters.put("fos", new Float(f));
    }

    public void setFontSize(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setFontSize(f);
    }

    private void setLabelAngle(float f) {
        Attributes.put("la", "float");
        this.Numeric_Parameters.put("la", new Float(f));
    }

    private void setLabelAngle(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setLabelAngle(f);
    }

    private void setLabelPhi(float f) {
        Attributes.put("lphi", "float");
        this.Numeric_Parameters.put("lphi", new Float(f));
    }

    private void setLabelPhi(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setLabelPhi(f);
    }

    private void setLabelRadius(float f) {
        Attributes.put("lr", "float");
        this.Numeric_Parameters.put("lr", new Float(f));
    }

    public void setLabelRadius(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setLabelRadius(f);
    }

    private void setLabelColor(String s) {
        if (s != null) {
            String[] number = s.split(" ");
            if (NETFileFunctions.isAFloat(number[0], "float") || NETFileFunctions.isAnInteger(number[0], "int")) {
                Attributes.put("lc", "float");
                this.Numeric_Parameters.put("lc", s);
            } else {
                Attributes.put("lc", "string");
                this.String_Parameters.put("lc", s);
            }
        }
    }

    private void setXScaleFactor(float f) {
        Attributes.put("x_fact", "float");
        this.Numeric_Parameters.put("x_fact", new Float(f));
    }

    public void setXScaleFactor(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setXScaleFactor(f);
    }

    private void setYScaleFactor(float f) {
        Attributes.put("y_fact", "float");
        this.Numeric_Parameters.put("y_fact", new Float(f));
    }

    public void setYScaleFactor(String s) {
        float f = NETFileFunctions.asAFloat(s);
        this.setYScaleFactor(f);
    }

    private void setCornerRadius(float f) {
        Attributes.put("r", "float");
        this.Numeric_Parameters.put("r", new Float(f));
    }

    private void setCornerRadius(String s) throws NETFileFormatException {
        try {
            float f = NETFileFunctions.asAFloat(s);
            this.setCornerRadius(f);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NETFileFormatException(String.valueOf(s) + " is not a valid value for the parameter " + "r");
        }
    }

    private void setDiamondRatio(float f) {
        Attributes.put("q", "float");
        this.Numeric_Parameters.put("q", new Float(f));
    }

    public void setDiamondRatio(String s) throws NETFileFormatException {
        try {
            float f = NETFileFunctions.asAFloat(s);
            this.setDiamondRatio(f);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NETFileFormatException(String.valueOf(s) + " is not a valid value for parameter " + "q");
        }
    }

    protected static void clearAttributes() {
        Attributes.clear();
    }

    public static List getVertexAttributes() {
        ArrayList<NETAttribute> attributeList = new ArrayList<NETAttribute>();
        for (String s : Attributes.keySet()) {
            attributeList.add(new NETAttribute(s, (String)Attributes.get(s)));
        }
        return attributeList;
    }

    public String getLabel() {
        return this.label;
    }

    public int getID() {
        return this.id;
    }

    public float getXpos() {
        return ((Float)this.Numeric_Parameters.get("xpos")).floatValue();
    }

    public float getYpos() {
        return ((Float)this.Numeric_Parameters.get("ypos")).floatValue();
    }

    public float getZpos() {
        return ((Float)this.Numeric_Parameters.get("zpos")).floatValue();
    }

    public String getShape() {
        return (String)this.String_Parameters.get("shape");
    }

    public boolean isValid() {
        return this.valid;
    }

    public Object getAttribute(String s) {
        String st = (String)Attributes.get(s);
        if (st == null) {
            return null;
        }
        if (s.equalsIgnoreCase("id")) {
            return new Integer(this.getID());
        }
        if (s.equalsIgnoreCase("label")) {
            return this.getLabel();
        }
        if (st.equalsIgnoreCase("float")) {
            return this.Numeric_Parameters.get(s);
        }
        return this.String_Parameters.get(s);
    }

    public static boolean betweenZeroandOne(float f) {
        float val = f;
        if ((double)val > 1.0E-6 || (double)val < 1.000001) {
            return true;
        }
        val = 1.0f - f;
        return (double)val > 1.0E-7 || (double)val < 1.000001;
    }

    public String toString() {
        String output = "";
        for (String s : Attributes.keySet()) {
            output = String.valueOf(output) + s + ":" + this.getAttribute(s) + " ";
        }
        return output;
    }
}

