/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.pajeknet.reader;

import edu.iu.nwb.converter.pajeknet.common.NETFileValidator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class NETValidation
implements AlgorithmFactory {
    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new NETValidationAlgorithm(data, parameters, context);
    }

    public class NETValidationAlgorithm
    implements Algorithm {
        private String inNetFileName;

        public NETValidationAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
            this.inNetFileName = (String)data[0].getData();
        }

        public Data[] execute() throws AlgorithmExecutionException {
            File inputFileData = new File(this.inNetFileName);
            NETFileValidator validator = new NETFileValidator();
            try {
                validator.validateNETFormat(inputFileData);
                if (validator.getValidationResult()) {
                    return this.createOutData(this.inNetFileName, inputFileData);
                }
                String message = "Sorry, your file does not comply with the NET File Format Specification.\nPlease review the latest NET File Format Specification at http://vlado.fmf.uni-lj.si/pub/networks/pajek/doc/pajekman.pdf, and update your file. \n" + validator.getErrorMessages();
                throw new AlgorithmExecutionException(message);
            }
            catch (FileNotFoundException e) {
                String message = "Couldn't find Pajek .net file: " + e.getMessage();
                throw new AlgorithmExecutionException(message, (Throwable)e);
            }
            catch (IOException e) {
                String message = "File access error: " + e.getMessage();
                throw new AlgorithmExecutionException(message, (Throwable)e);
            }
        }

        private Data[] createOutData(String fileHandler, File inputFileData) {
            Data[] validationData = new Data[]{new BasicData((Object)inputFileData, "file:application/pajeknet")};
            validationData[0].getMetadata().put("Label", "Pajek .net file: " + fileHandler);
            validationData[0].getMetadata().put("Type", "Network");
            return validationData;
        }
    }
}

