/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.pajeknet.writer;

import edu.iu.nwb.converter.pajeknet.common.NETFileValidator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Dictionary;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.algorithm.AlgorithmFactory;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;

public class NETFileHandler
implements AlgorithmFactory {
    public Algorithm createAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        return new NETFileHandlerAlg(data, parameters, context);
    }

    public class NETFileHandlerAlg
    implements Algorithm {
        private Object inData;
        private String inFormat;

        public NETFileHandlerAlg(Data[] data, Dictionary parameters, CIShellContext context) {
            this.inData = data[0].getData();
            this.inFormat = data[0].getFormat();
        }

        public Data[] execute() throws AlgorithmExecutionException {
            if (this.inData instanceof File) {
                if (this.inFormat.equals("file:application/pajeknet")) {
                    NETFileValidator validator = new NETFileValidator();
                    try {
                        validator.validateNETFormat((File)this.inData);
                        if (validator.getValidationResult()) {
                            return new Data[]{new BasicData(this.inData, "file-ext:net")};
                        }
                        throw new AlgorithmExecutionException("Sorry, your file does not seem to comply with the Pajek .net File Format Specification.We are writing it out anyway.\nPlease review the latest NET File Format Specification at http://vlado.fmf.uni-lj.si/pub/networks/pajek/doc/pajekman.pdf, and update your file." + validator.getErrorMessages());
                    }
                    catch (FileNotFoundException e) {
                        String message = "Couldn't find Pajek .net file: " + e.getMessage();
                        throw new AlgorithmExecutionException(message, (Throwable)e);
                    }
                    catch (IOException e) {
                        String message = "File access error: " + e.getMessage();
                        throw new AlgorithmExecutionException(message, (Throwable)e);
                    }
                }
                String message = "Expected file:application/pajeknet, but the input format is " + this.inFormat;
                throw new AlgorithmExecutionException(message);
            }
            String message = "Expected a File, but the input data is " + this.inData.getClass().getName();
            throw new AlgorithmExecutionException(message);
        }
    }
}

