/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusebibtex;

import bibtex.dom.BibtexAbstractEntry;
import bibtex.dom.BibtexAbstractValue;
import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexFile;
import bibtex.expansions.ExpansionException;
import bibtex.expansions.MacroReferenceExpander;
import bibtex.parser.BibtexParser;
import bibtex.parser.ParseException;
import edu.iu.nwb.converter.prefusebibtex.BibtexValueFormatter;
import edu.iu.nwb.converter.prefusebibtex.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Dictionary;
import java.util.Map;
import org.cishell.framework.CIShellContext;
import org.cishell.framework.algorithm.Algorithm;
import org.cishell.framework.algorithm.AlgorithmExecutionException;
import org.cishell.framework.data.BasicData;
import org.cishell.framework.data.Data;
import org.cishell.utilities.UnicodeReader;
import org.osgi.service.log.LogService;
import prefuse.data.DataTypeException;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.column.Column;
import prefuse.util.collections.IntIterator;

public class BibtexReaderAlgorithm
implements Algorithm {
    public static final String ENTRY_TYPE_KEY = "entry type";
    public static final String ENTRY_KEY_KEY = "entry key";
    public static final String AUTHOR_COLUMN_NAME = "author";
    public static final String ORIG_AUTHOR_COLUMN_SEPARATOR = " and ";
    public static final String NEW_AUTHOR_COLUMN_SEPARATOR = "|";
    private LogService log;
    private BibtexValueFormatter valueFormatter;
    private File inBibtexFile;

    public BibtexReaderAlgorithm(Data[] data, Dictionary parameters, CIShellContext context) {
        this.inBibtexFile = (File)data[0].getData();
        this.log = (LogService)context.getService(LogService.class.getName());
        this.valueFormatter = new BibtexValueFormatter(this.log);
    }

    public Data[] execute() throws AlgorithmExecutionException {
        String bibtexFilePath = this.inBibtexFile.getAbsolutePath();
        BibtexFile parsedBibtex = this.parseBibtex(bibtexFilePath);
        Table bibtexTable = this.makeTable(parsedBibtex);
        bibtexTable = this.normalizeAuthorNames(bibtexTable);
        Data[] bibtexReturnData = this.createOutData(bibtexTable, bibtexFilePath);
        return bibtexReturnData;
    }

    private Data[] createOutData(Table bibtex, String bibtexFilePath) {
        Data[] tableToReturnData = new Data[]{new BasicData((Object)bibtex, Table.class.getName())};
        tableToReturnData[0].getMetadata().put("Label", "Parsed BibTeX file: " + bibtexFilePath);
        tableToReturnData[0].getMetadata().put("Type", "Table");
        return tableToReturnData;
    }

    private Table makeTable(BibtexFile bibtex) throws AlgorithmExecutionException {
        TableData table = this.createDefaultEmptyTable();
        for (BibtexAbstractEntry abstractEntry : bibtex.getEntries()) {
            if (!(abstractEntry instanceof BibtexEntry)) continue;
            BibtexEntry entry = (BibtexEntry)abstractEntry;
            table.moveOnToNextRow();
            table.setString(ENTRY_TYPE_KEY, entry.getEntryType());
            table.setString(ENTRY_KEY_KEY, entry.getEntryKey());
            Map entryFields = entry.getFields();
            for (String fieldKey : entryFields.keySet()) {
                BibtexAbstractValue fieldVal = (BibtexAbstractValue)entryFields.get(fieldKey);
                table.setString(fieldKey, this.valueFormatter.formatFieldValue(fieldVal));
            }
        }
        return table.getPrefuseTable();
    }

    private BibtexFile parseBibtex(String bibtexFilePath) throws AlgorithmExecutionException {
        BibtexFile bibtexFile = new BibtexFile();
        BibtexParser parser = new BibtexParser(false);
        try {
            try {
                parser.parse(bibtexFile, (Reader)new UnicodeReader((InputStream)new FileInputStream(bibtexFilePath)));
            }
            catch (FileNotFoundException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (ParseException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new AlgorithmExecutionException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.printNonFatalExceptions((Exception[])parser.getExceptions(), bibtexFile.getEntries().size());
        }
        try {
            MacroReferenceExpander macroExpander = new MacroReferenceExpander(true, true, false, false);
            macroExpander.expand(bibtexFile);
        }
        catch (ExpansionException e) {
            throw new AlgorithmExecutionException("Error occurred while parsing bibtex file.", (Throwable)e);
        }
        return bibtexFile;
    }

    private TableData createDefaultEmptyTable() {
        int startingCapacity = 25;
        Schema s = new Schema(startingCapacity);
        return new TableData(s);
    }

    private void add(Schema schema, String column) {
        schema.addColumn(column, String.class);
    }

    private Table normalizeAuthorNames(Table bibtexTable) {
        Column authorColumn = bibtexTable.getColumn(AUTHOR_COLUMN_NAME);
        if (authorColumn == null) {
            this.printNoAuthorColumnWarning();
            return bibtexTable;
        }
        try {
            IntIterator tableIt = bibtexTable.rows();
            while (tableIt.hasNext()) {
                int rowIndex = tableIt.nextInt();
                String authors = authorColumn.getString(rowIndex);
                if (authors == null || authors.equals("")) continue;
                String normalizedAuthors = this.normalizeAuthorNames(authors);
                authorColumn.setString(normalizedAuthors, rowIndex);
            }
        }
        catch (DataTypeException e) {
            this.printColumnNotOfTypeStringWarning(e);
            return bibtexTable;
        }
        return bibtexTable;
    }

    private String normalizeAuthorNames(String authorNames) {
        String[] eachAuthorName = authorNames.split(ORIG_AUTHOR_COLUMN_SEPARATOR);
        String normalizedAuthorNames = StringUtil.join(eachAuthorName, NEW_AUTHOR_COLUMN_SEPARATOR);
        return normalizedAuthorNames;
    }

    private void printNonFatalExceptions(Exception[] exceptions, int numTotalEntries) {
        if (exceptions.length > 0) {
            this.log.log(2, "Non-fatal exceptions:\n");
            int i = 0;
            while (i < exceptions.length) {
                String message = exceptions[i].getMessage();
                if (message == null) {
                    message = "";
                }
                this.log.log(2, "  " + message, (Throwable)exceptions[i]);
                ++i;
            }
            float percentFlawed = (float)exceptions.length / (float)numTotalEntries;
            String percentFlawedAsString = String.valueOf(percentFlawed * 100.0f);
            percentFlawedAsString = percentFlawedAsString.substring(0, 4);
            this.log.log(2, exceptions.length + " non-fatal errors were found out of  " + numTotalEntries + " entries. Each will usually cause one or more fields to " + "be lost for a single entry.");
        } else {
            this.log.log(3, "File successfully parsed -- no issues arose.");
        }
    }

    private void printColumnNotOfTypeStringWarning(DataTypeException e) {
        this.log.log(2, "The column 'author' in the bibtex file cannot be normalized, because it cannot be interpreted as text.", (Throwable)e);
    }

    private void printNoAuthorColumnWarning() {
        this.log.log(2, "Unable to find column with the name 'author' in bibtex file. We will continue on without attempting to normalize this column");
    }

    private class TableData {
        private Table table;
        private int currentRow;
        private boolean currentRowIsFinished;

        public TableData(Schema schema) {
            this.table = schema.instantiate();
            this.currentRowIsFinished = true;
        }

        public void moveOnToNextRow() {
            this.currentRowIsFinished = true;
        }

        public void setString(String columnTag, String value) throws AlgorithmExecutionException {
            this.ensureRowNotFinishedYet();
            try {
                this.table.setString(this.currentRow, columnTag, value);
            }
            catch (Exception exception) {
                this.addColumn(columnTag, String.class);
                try {
                    this.table.setString(this.currentRow, columnTag, value);
                }
                catch (Exception e2) {
                    throw new AlgorithmExecutionException((Throwable)e2);
                }
            }
        }

        public void addColumn(String columnName, Class columnType) {
            this.table.addColumn(columnName, columnType);
        }

        public Table getPrefuseTable() {
            return this.table;
        }

        private void ensureRowNotFinishedYet() {
            if (this.currentRowIsFinished) {
                this.currentRow = this.table.addRow();
                this.currentRowIsFinished = false;
            }
        }
    }
}

