/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.nwb.converter.prefusebibtex;

import bibtex.dom.BibtexAbstractValue;
import bibtex.dom.BibtexConcatenatedValue;
import bibtex.dom.BibtexMacroReference;
import bibtex.dom.BibtexMultipleValues;
import bibtex.dom.BibtexString;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.log.LogService;

public class BibtexValueFormatter {
    private static final String MULTI_VALUED_SEP_CHAR = ",";
    private static final boolean CLEANING_ENABLED = true;
    private LogService log;

    public BibtexValueFormatter(LogService log) {
        this.log = log;
    }

    public String formatFieldValue(BibtexAbstractValue value) {
        if (value instanceof BibtexString) {
            return this.formatFieldValue((BibtexString)value);
        }
        if (value instanceof BibtexConcatenatedValue) {
            return this.formatFieldValue((BibtexConcatenatedValue)value);
        }
        if (value instanceof BibtexMultipleValues) {
            return this.formatFieldValue((BibtexMultipleValues)value);
        }
        if (value instanceof BibtexMacroReference) {
            return this.formatFieldValue((BibtexMacroReference)value);
        }
        this.log.log(2, "Unexpected bibtex field value " + value.toString() + " of type " + value.getClass().getName() + ". Parsing contents in a generic fashion.");
        return value.toString();
    }

    private String formatFieldValue(BibtexConcatenatedValue value) {
        BibtexAbstractValue left = value.getLeft();
        BibtexAbstractValue right = value.getRight();
        return String.valueOf(this.formatFieldValue(left)) + this.formatFieldValue(right);
    }

    private String formatFieldValue(BibtexMultipleValues value) {
        StringBuffer parsedValue = new StringBuffer();
        List values = value.getValues();
        Iterator valuesIt = values.iterator();
        while (valuesIt.hasNext()) {
            parsedValue.append(this.formatFieldValue((BibtexAbstractValue)valuesIt.next()));
            if (!valuesIt.hasNext()) continue;
            parsedValue.append(MULTI_VALUED_SEP_CHAR);
        }
        return parsedValue.toString();
    }

    private String formatFieldValue(BibtexString value) {
        String content = value.getContent();
        content = this.cleanLatexString(content);
        return content;
    }

    private String formatFieldValue(BibtexMacroReference value) {
        return value.getKey();
    }

    public String cleanLatexString(String s) {
        String cleanedString = s.startsWith("{") && s.endsWith("}") || s.startsWith("\"") && s.endsWith("\"") ? s.substring(1, s.length() - 1) : s;
        return cleanedString;
    }
}

